// File: Contraster.C
//
// (c) 1996 Mayur Patel

#include <Contraster.h>

#include <assert.h>

Contraster::Contraster( InputImage *pIn, float rLumFactor, float rGrey )
:  InputImage( Real )
{
   _pHost = pIn;
   if ( _pHost )
      _pHost->registerReference();
   _rLumFactor = rLumFactor;
   _rGrey = rGrey;
}


Contraster::~Contraster( void )
{
   if ( _pHost )
      _pHost->unregisterReference();
   return;
}


int
Contraster::fillTile( ImageTile *pWriteHere )
{
   int			iRet = 0;
   ImageTile		*pTile;
   
   unsigned long	lLoop;   
   register float	*pSrc;
   register float	*pDest;
   
   if ( _pHost && pWriteHere )
   {
      pTile = _pHost->newTile( pWriteHere->getArea() );
      if ( pTile )
      {
         assert( getType() == pWriteHere->getType() );   
         pTile->typecast( Real );
         
         pSrc = (float *) pTile->getBuffer();
         pDest = (float *) pWriteHere->getBuffer();
         
         lLoop = 
            pWriteHere->getArea().width *
            pWriteHere->getArea().height;
            
         while ( lLoop )
         {
            lLoop--;
                        
            // contrast enhance:
            //
            *pDest = _rGrey + (( *pSrc - _rGrey ) * _rLumFactor );
            
            // clamp over-exposure & under-exposure:
            //
            *pDest = ( *pDest < 0.0 ) ? ( 0.0 ) : ( *pDest );
            *pDest = ( *pDest > 1.0 ) ? ( 1.0 ) : ( *pDest );
            
            pDest++;
            pSrc++;
         }
                  
         pTile->deleteTile();
      }      
   }
   
   return ( iRet );
}
