// url.c

#include <stdio.h>
#include <stdlib.h>
#include "url.h"
#include "MCFile.h"

#ifndef PATH_DELIMITER
#define PATH_DELIMITER ':'
#endif

#ifdef PLUGIN
#include "npapi.h"
#endif

extern char *p3dCache;

int IsLocalFile(const char *url, char converted[])
{
	char *startPtr, *urlPtr;
	int urlLen = StrLen(url);
	int convUrlLen = urlLen - 8;

	if (CompareStrCaseless("file:///", url))
	{	
		startPtr = converted; // move beyond file:/// prefix
		urlPtr = (char *)url + 8;
		while ((*startPtr = *urlPtr++) != NULL)
		{
			if (*startPtr == '/')
				*startPtr = PATH_DELIMITER;
			else if (*startPtr == '|')
				*startPtr = ':';
			startPtr++;
		}
		*(++startPtr) = 0;	
		return 1;
	}
	return 0;
}

DocType GetDocType(const char *url)
{
	int l, n;
	char *index, *endPtr;
		
	l = StrLen(url);
	if (l == 0 || l > 255)
	{
		return INVALIDDOC;
	}
	index = (char *)(url + l - 1);
	// rewind & look for dir char
	for (n = 1; n <= l; n++)
	{
		if ((*index == '\\') || (*index == '/') || (*index == '|') || (*index == ':')) // DOS Mac or UNIX
			break;
		index--;
	}
	index++;	
	endPtr = strchr(index, '.');
	if (!endPtr)
		return NODOTDOC;

	l = StrLen(url);
	if (l == 0)
	{
		return INVALIDDOC;
	}
	if (CompareStrCaseless(endPtr, ".rwx"))
		return RWXDOC;
	else if (CompareStrCaseless(endPtr, ".rwb"))
		return RWBDOC;		
	else if (CompareStrCaseless(endPtr, ".p3d"))
		return P3DDOC;		
	else if (CompareStrCaseless(endPtr, ".avi"))
		return AVIDOC;
	else if (CompareStrCaseless(endPtr, ".wav"))
		return WAVDOC;
	else if (CompareStrCaseless(endPtr, ".bmp"))
		return BMPDOC;
	else if (CompareStrCaseless(endPtr, ".mid"))
		return MIDDOC;
	else if (CompareStrCaseless(endPtr, ".spr"))
		return SPRDOC;
	else if (CompareStrCaseless(endPtr, ".spm"))
		return SPMDOC;
	else if (CompareStrCaseless(endPtr, ".mpx"))
		return MPXDOC;
	else if (CompareStrCaseless(endPtr, ".scn"))
		return SCNDOC;
	else if (CompareStrCaseless(endPtr, ".wrl"))
		return VRMLDOC;
	else if (CompareStrCaseless(endPtr, ".mov"))
		return MOVDOC;
	else if (CompareStrCaseless(endPtr, ".qtap"))
		return MOVDOC;	
	else if (CompareStrCaseless(endPtr, ".DeepV"))
		return DEEPVDOC;
	else if (CompareStrCaseless(endPtr, ".DVX"))
		return DEEPVDOC;								
	else if ((CompareStrCaseless(endPtr, ".pic")) ||
			 (CompareStrCaseless(endPtr, ".pict"))||
			 (CompareStrCaseless(endPtr, ".pct")))
		return PICDOC;		
	else if (CompareStrCaseless(endPtr, ".qd3"))
		return QD3DOC;
	else if (CompareStrCaseless(endPtr, ".3dm"))
		return MF3DOC;
	else if (CompareStrCaseless(endPtr, ".txt"))
		return TXTDOC;
	else
		return INVALIDDOC;
}

DocType GetMimeType(const char *url)
{
	int l;
	char endPtr[64];
	
	l = StrLen(url);
	if (l == 0)
	{
		return INVALIDDOC;
	}
	ExtractFileName(url, endPtr); // finds forward slash
	
	if (CompareStrCaseless(endPtr, "quicktime"))
		return MOVDOC;
	else if (CompareStrCaseless(endPtr, "x-p3d"))
		return P3DDOC;		
	else if (CompareStrCaseless(endPtr, "QTAutoPlay"))
		return MOVDOC;			
	else if (CompareStrCaseless(endPtr, "x-rwx"))
		return RWXDOC;
	else if (CompareStrCaseless(endPtr, "x-avi"))
		return AVIDOC;
	else if (CompareStrCaseless(endPtr, "x-wave"))
		return WAVDOC;
	else if (CompareStrCaseless(endPtr, "x-bitmap"))
		return BMPDOC;
	else if (CompareStrCaseless(endPtr, "x-midi"))
		return MIDDOC;
	else if (CompareStrCaseless(endPtr, "x-sprite"))
		return SPRDOC;
	else if (CompareStrCaseless(endPtr, "spm"))
		return SPMDOC;
	else if (CompareStrCaseless(endPtr, "mpx"))
		return MPXDOC;
	else if (CompareStrCaseless(endPtr, "x-scene"))
		return SCNDOC;
	else if (CompareStrCaseless(endPtr, "vrml"))
		return VRMLDOC;
	else if (CompareStrCaseless(endPtr, "movie"))
		return MOVDOC;		
	else if (CompareStrCaseless(endPtr, "pict"))
		return PICDOC;
	else if (CompareStrCaseless(endPtr, "qd3"))
		return QD3DOC;	
	else if (CompareStrCaseless(endPtr, "3dmf"))
		return MF3DOC;
	else if (CompareStrCaseless(endPtr, "text"))
		return TXTDOC;
	else if (CompareStrCaseless(endPtr, "DeepV"))
		return DEEPVDOC;
	else if (CompareStrCaseless(endPtr, ".DVX"))
		return DEEPVDOC;										
	else if (CompareStrCaseless(endPtr, "DeepVB"))
		return RWBDOC;	
	else
		return INVALIDDOC;
}

DocType ExtractFileName(const char *url, char *returnFileName)
{
	int l, n;
	char *index, *endPtr;
		
	l = StrLen(url);
	if (l == 0 || l > 255)
	{
		return INVALIDDOC;
	}
	index = (char *)(url + l - 1);
	// rewind & look for dir char
	for (n = 1; n <= l; n++)
	{
		if ((*index == '\\') || (*index == '/') || (*index == '|') || (*index == ':')) // DOS Mac or UNIX
			break;
		index--;
	}
	index++;
	strcpy(returnFileName, index);
	
	endPtr = strchr(index, '.');
	if (!endPtr)
		return NODOTDOC;
		
	if (CompareStrCaseless(endPtr, ".rwx"))
		return RWXDOC;
	else if (CompareStrCaseless(endPtr, ".rwb"))
		return RWBDOC;
	else if (CompareStrCaseless(endPtr, ".p3d"))
		return P3DDOC;		
	else if (CompareStrCaseless(endPtr, ".avi"))
		return AVIDOC;
	else if (CompareStrCaseless(endPtr, ".wav"))
		return WAVDOC;
	else if (CompareStrCaseless(endPtr, ".bmp"))
		return BMPDOC;
	else if (CompareStrCaseless(endPtr, ".mid"))
		return MIDDOC;
	else if (CompareStrCaseless(endPtr, ".spr"))
		return SPRDOC;
	else if (CompareStrCaseless(endPtr, ".spm"))
		return SPMDOC;
	else if (CompareStrCaseless(endPtr, ".mpx"))
		return MPXDOC;
	else if (CompareStrCaseless(endPtr, ".scn"))
		return SCNDOC;
	else if (CompareStrCaseless(endPtr, ".wrl"))
		return VRMLDOC;
	else if (CompareStrCaseless(endPtr, ".mov"))
		return MOVDOC;
	else if (CompareStrCaseless(endPtr, ".qtap"))
		return MOVDOC;
	else if (CompareStrCaseless(endPtr, ".DeepV"))
		return DEEPVDOC;
	else if (CompareStrCaseless(endPtr, ".DVX"))
		return DEEPVDOC;								
	else if (CompareStrCaseless(endPtr, ".pic"))
		return PICDOC;
	else if (CompareStrCaseless(endPtr, ".qd3"))
		return QD3DOC;
	else if (CompareStrCaseless(endPtr, ".3dm"))
		return MF3DOC;
	else if (CompareStrCaseless(endPtr, ".txt"))
		return TXTDOC;
	else if ((CompareStrCaseless(endPtr, ".pic")) ||
			 (CompareStrCaseless(endPtr, ".pict"))||
			 (CompareStrCaseless(endPtr, ".pct")))
		return PICDOC;		
	else if (!strchr(returnFileName, ',')) // it may be raster file with no ext
		return BMPDOC;
	else
		return INVALIDDOC;
}

void ExtractPathName(const char *url, char *prefix)
 {
	int l, n;
	char *index, *endPtr;
	
	l = StrLen(url);
	if (l == 0)
	{
		*prefix = 0;
		return;
	}
	strcpy(prefix, url);
	index = endPtr = (char *)(prefix + l);
	if (*index-- != '\0') // not null terminated!
	{
		*prefix = 0;
		return;
	}
	// rewind & look for dir char
		
	for (n = 1; n <= l; n++)
	{
		if ((*index == '\\') || (*index == '/') || (*index == '|') || (*index == ':')) // DOS or UNIX
			break;
		index--;
	}
	index++;
	*index = 0;
}

int FileSize(FILE *fp)
{
	int savedSpot = ftell(fp);
	fseek(fp, 0, SEEK_END);
	int len = ftell(fp);
	fseek(fp, savedSpot, SEEK_SET);
	return len;
}

void Copy_file(const char *theFile, const char *theDest)
{
	FILE *fp, *dp;
	void *buff;
	int len, didRead;
	
	fp = fopen(theFile, "rb");
	if (fp)
	{
		len = FileSize(fp);
		buff = calloc(len, 1);
		if (buff)
		{
			didRead = fread(buff, len, 1, fp);
			if (didRead > 0)
			{	
				dp = fopen(theDest, "wb");
				if (dp)
				{
					fwrite(buff, len, 1, dp);
					fclose(dp);
				}
			}
			free(buff);
		}
		fclose(fp);
	}
}
		
int GoURL(const char *url, void *NPInstance)
{
	DocType doc;
	char *win = "_top"; // Netscape ID for main window
	char scratchBuff[255];
	
	if (!(*url))
		return 0;

#ifndef PLUGIN
#ifdef WIN32
	doc;
	NPInstance;	
	sprintf(scratchBuff, "In plugin mode, Netscape would now be "
		"pointed to the URL: %s", url);
	MessageBox(NULL, scratchBuff, "URL request", MB_OK);
#endif
	doc;
	scratchBuff;
	NPInstance;
	return 0;
#else
	scratchBuff;
	doc = GetDocType(url);
	// we need to cache the url data, as ClearScene
	// will destroy the clump holding it

	if (NPInstance != NULL)
	{
		strcpy(scratchBuff, url);
		return (!(NPN_GetURL((_NPP *)NPInstance, scratchBuff, win)));
	}
	return 0;
#endif
}

void DumpToFile(char *fileName, char *directory, void *data, int dataLen)
{
	char tempPath[255];

	strcpy(tempPath, directory); // directory has "\\"
	strcat(tempPath, fileName);
	FILE *fp = fopen(tempPath, "a");

	if (fp)
	{
		fwrite(data, dataLen, 1, fp);
		fclose(fp);
	}
}

int FindLocal(char *fileName, char *directory)
{
	char tempPath[255];

	strcpy(tempPath, directory); // directory has "\\"
	strcat(tempPath, fileName);
	
	FILE *fp = fopen(tempPath, "r");
	if (fp)
	{
		fclose(fp);
		return 1;
	}
	return 0;
}

void ExtractLeafName(const char *url, char *returnFileName)
{
	int l, n;
	char *index, *endPtr;

	l = StrLen(url);
	if (l == 0)
	{
		*returnFileName = 0;
		return;
	}
	index = endPtr = (char *)(url + l);
	if (*index-- != '\0') // not null terminated!
	{
		*returnFileName = 0;
		return;
	}
	// rewind & look for dir char
		
	for (n = 1; n <= l; n++)
	{
		if ((*index == '\\') || (*index == '/') || (*index == '|') || (*index == ':')) // DOS Mac or UNIX
			break;
		index--;
	}
	index++;
	strcpy(returnFileName, index);
	index = returnFileName;
	while (*index)
	{
		if (*index == '.')
		{
			*index = 0;
			return;
		}
		index++;
	}
}
