// Scanner.cpp

#include "Scanner.h"

#define HIBIT 1 << 15

KeyScanner::KeyScanner(int *glob)
{
	lastKeys = newKeys = k_none;
	globCache = glob;
	hPos = vPos = 0;
}

KeyScanner::~KeyScanner()
{
}

void KeyScanner::Scan(unsigned long *flags)
{
	long f = *flags;
#ifdef MAC
	f = IsPressed(arrow_left) 	  		|
		IsPressed(arrow_right) 	<< 1 	|
		IsPressed(arrow_up)		<< 2	|
		IsPressed(arrow_down)	<< 3 	|
		IsPressed(spacebar)		<< 4 	|
		IsPressed(controlkey)	<< 5 	|
		IsPressed(optionkey)	<< 6	|
		IsPressed(tabkey)		<< 7	|
		IsPressed(escapekey)	<< 8	|
		IsPressed(shiftkey)		<< 9	|
		IsPressed(pageupkey)	<<10	|
		IsPressed(pagedownkey)	<<11	|
		IsPressed(homekey)		<<12	|
		IsPressed(endkey)		<<13	|
		IsPressed(insertkey)	<<14	|
		IsPressed(helpkey)		<<15;
#else
	f=	IsPressed(arrow_left) 	>>15	|
		IsPressed(arrow_right) 	>>14 	|
		IsPressed(arrow_up)		>>13	|
		IsPressed(arrow_down)	>>12 	|
		IsPressed(spacebar)		>>11 	|
		IsPressed(controlkey)	>>10 	|
		IsPressed(optionkey)	>> 9	|
		IsPressed(tabkey)		>> 8	|
		IsPressed(escapekey)	>> 7	|
		IsPressed(shiftkey)		>> 6	|
		IsPressed(pageupkey)	>> 5	|
		IsPressed(pagedownkey)	>> 4	|
		IsPressed(homekey)		>> 3	|
		IsPressed(endkey)		>> 2	|
		IsPressed(insertkey)	>> 1	|
		IsPressed(helpkey);
#endif
	*flags = f;
}

Keys KeyScanner::Scan()
{
	int hMov, vMov;

	newKeys = k_none;
	if (IsPressed(arrow_right))
	{
		newKeys |= k_right;
	} 
	else if (IsPressed(arrow_left))
	{
		newKeys |= k_left;
	}
	if (IsPressed(arrow_up))
	{
		newKeys |= k_up;
	} 
	else if (IsPressed(arrow_down))
	{
		newKeys |= k_down;
	}
	if (IsPressed(optionkey))
	{
		newKeys |= k_alt;
	}
	if (IsPressed(controlkey))
	{
		newKeys |= k_ctrl;
	}
	if (IsPressed(shiftkey))
	{
		newKeys |= k_shift;
	}
	if (IsPressed(spacebar))
	{
		newKeys |= k_space;
	}
	else
	{
		if (lastKeys & k_space) // was down, now up
			hitSpace = 1;
	}
	if (IsPressed(tabkey))
	{
		if (!(newKeys & k_alt))
			newKeys |= k_tab;
	}
	else
	{
		if (lastKeys & k_tab) // was down, now up
			hitEsc = 1;
	}
	if (IsPressed(escapekey))
	{
		if (!(newKeys & k_alt) && !(newKeys & k_ctrl))
		{
			newKeys |= k_esc;
			*globCache = 0; // switch global "active" flag to off
		}
	}
	else
	{
		if (lastKeys & k_tab) // was down, now up
			hitTab = 1;
	}
	lastKeys = newKeys;
		
	hMov = vMov = 0;
	if (newKeys & k_left)
	{
		// scroll pointer left
		hPos -= 1;
		if (hPos < -16)
			hPos = -16;
		hMov = 1;
	}
	else if (newKeys & k_right)
	{
		// scroll pointer right
		hPos += 1;
		if (hPos >= 16)
			hPos = 16;
		hMov = 1;
	}
	if (newKeys & k_up)
	{
		vPos += 1;
		if (vPos >= 16)
			vPos = 16;
		vMov = 1;
	}
	else if (newKeys & k_down)
	{
		vPos -= 1;
		if (vPos < -16)
			vPos = -16;
		vMov = 1;
	}
	if (hPos > 0)
	{
		if (!hMov)
			hPos--;
	}
	else if (hPos < 0)
	{
		if (!hMov)
			hPos++;
	}
	if (vPos > 0)
	{
		if (!vMov)
			vPos--;
	}
	else if (vPos < 0)
	{
		if (!vMov)
			vPos++;
	}
	return newKeys;
}

inline int KeyScanner::tab()
{
	if (!hitTab)
		return 0;
	hitTab = 0;
	return 1;
}

int KeyScanner::esc()
{
	if (!hitEsc)
		return 0;
	hitEsc = 0;
	return 1;
}

inline int KeyScanner::space()
{
	if (!hitSpace)
		return 0;
	hitSpace = 0;
	return 1;
}

#ifdef WIN32
inline int KeyScanner::IsPressed(int k)
{
	return (GetAsyncKeyState(k) & HIBIT);
}
#else

#include <Events.h>

inline int KeyScanner::IsPressed(unsigned short k)
// k =  any keyboard scan code, 0-127
{
	char ka[256];
	int res;
		
	GetKeys((unsigned long *)ka);
	res = ( ka[k>>3] >> (k & 7) ) & 1;
	if (res)
		return res; // debug again!
	else
		return 0;
}

int KeyScanner::TestPress(void)
{
	int n, c;
	
	for (n = 0; n < 128; n++)
		if (IsPressed(n))
			c = n;
	return c;
}
#endif