#ifndef RAVER_H
#define RAVER_H

#include "WinDOS.h"
#include "Renderer.h"

#define TEXBUFFWIDTH 128
#define TEXBUFFHEIGHT 128
#define TEXBUFFDEPTH 2
#define TEXBUFFSIZE TEXBUFFWIDTH * TEXBUFFHEIGHT * TEXBUFFDEPTH

typedef struct {
	unsigned char 	c;
	TQATexture		*tp;
} TexTable;
			
class Raver : public Renderer
{	
	bool			perspectiveZ;
protected:
	TQAVGouraud		topLeft, bottomLeft, topRight, bottomRight;
	TQAVTexture		topLeftTex, bottomLeftTex, topRightTex, bottomRightTex;
	int				thisColumn, previousColumn, gridWidth, gridHeight, gridResolution;
	Rgb				*pointGrid;

// pure virtual overrides		
	void 			DrawDot(int x, int y, float r, float g, float b);
	void			RenderStart() { QARenderStart (drawContext, NULL, cache); }
	void			RenderEnd() { QARenderEnd (drawContext, NULL); }
	
	// local functions
	void			InitTexTable();
	TQATexture 		*CreateRaveTexture(char *tex_data, int w, int h);
	TQATexture 		*CreateRaveTexture(char *tex_name);
	int  			InsertTexture(char tag, char *tex_data, int w, int h);
	int				CreateRaveWindow(int w, int h);
	TQAEngine 		*SetupEngine(TQADevice *device);	
	int 			CreateDrawContext(TQADevice *device, unsigned long flags);
		
public:
					Raver(int w, int h, void *d, int vls);
	void			Destroy();										
	int				InstallTextures(char *list_name);
	void			SetupPointGrid(int gridRes);
	void			TimeSlice(long keys);
	void			Load();
	void 			DumpInfo();
	
	TQAEngine		*engine;		
	TQADrawContext	*drawContext, *cache; // cache is not supported in current default RAVE engine
	TQATexture		*texArray256[256];
	TexTable		texTable[256];
	int				num_textures, num_engines;
	
};

#endif