// enum.cpp

#ifndef ENUM_H
#define ENUM_H

enum 
{	
	UNKNOWN, 
	SUNLIGHT,
	GLOBELIGHT,
	TORCHLIGHT,
	FLOOR,
	SPHERE,
	CUBE,
	CYLINDER,
	CONE,
	SIZEDSPHERE,
	SIZEDCUBE,
	SIZEDCYLINDER,
	SIZEDCONE,
	GRID,
	EXTERNAL_RWX,
	UNDEFINED_7
};
		
typedef enum
{
	T_NONE=0,
	T_SHAPE,
	T_SPRITE,
	T_HILITE,
	T_LIGHT,
	T_SHAPE_DUMMY,
	T_SPRITE_DUMMY
} Type;

typedef enum
{
    mmNoAction,
    mmScrollBackdrop,
    mmMoveAndTurnCamera,
    mmTiltCamera,
	// inertia movements:
    mmSpinClump,
    mmDragClump,
    mmDragClumpInZ,
	// still movements:
	mmTurnClump,
	mmMoveClump,
	mmPushClump,
	mmFly
} MMMode;

typedef enum
{
	F_NOTHING = 0,
	F_MOTION = 1,
	F_LOCKED = 2,
	F_ANIMATE = 4,
	F_EDITED = 8,
	F_DOHILITE = 16,
	F_POINTCLOUD = 32,	//NOTE: these 3 should be exclusive! SOLID takes pref
	F_WIREFRAME = 64,	// --
	F_SOLID = 128		// --s
} Clump_flags;

typedef enum
{
	pft_file,
	pft_url,
	pft_none = 0xFFFFFFFF
} PlayFileType;

typedef enum
{
	MMANoAction,
	MMASpinClump,
	MMAXYTranslateClump,
	MMAZTranslateClump,
	MMAPanAndZoomCamera,
	MMATiltCamera,
	MMARotateLight
} MMAType;

typedef enum
{
	INVALIDDOC=0,
	P3DDOC,
	BMPDOC,
	RWXDOC,
	MIDDOC,
	SPRDOC,
	SPMDOC,
	MPXDOC,
	AVIDOC,
	WAVDOC,
	SCNDOC,
	VRMLDOC,
	PICDOC,
	MOVDOC,
	QD3DOC,
	MF3DOC,
	TXTDOC,
	CPPDOC,
	RWBDOC,
	NODOTDOC,
	DEEPVDOC
}DocType;

typedef enum
{
	INVALIDRX=0,
	P3DRX,
	BMPRX,
	RWXRX,
	MIDRX,
	SPRRX,
	SPMRX,
	MPXRX,
	AVIRX,
	WAVRX,
	SCNRX,
	VRMLRX,
	PICRX,
	MOVRX,
	QD3RX,
	MF3RX,
	TXTRX,
	RWBRX
}ReceiveStatus;

typedef enum
{
	INVALIDRQ=0,
	P3DRQ,
	BMPRQ,
	RWXRQ,
	VRMLRQ,
	RWBRQ
}RequestStatus;

typedef enum
{
	move_not,
	move_left,
	move_right,
	move_up,
	move_down,
	move_forward,
	move_backward
} MoveDirection;

enum
{
	INTERNAL_CUBE = 2,
	INTERNAL_CYLINDER = 3,
	INTERNAL_CONE = 4,
	INTERNAL_GRID = 5,
	INTERNAL_SIZEDCUBE = 102,
	EXTERNAL_RWXFILE = 200
};

enum {
	RENDERER_DEEPV,
	RENDERER_RENDERWARE,
	RENDERER_DIRECT3D,
	RENDERER_QD3D
};
#endif