// Scanner.h

#ifndef SCANNER_H
#define SCANNER_H

#ifdef WIN32
#include <windows.h>
#endif

#include "codes.h"

class KeyScanner
{
	Keys	lastKeys, newKeys;
	int		hitSpace, hitTab, hitEsc;
	int		*globCache;

public:	
	#ifdef WIN32
	static enum 
	{	
		arrow_left = VK_LEFT,
		arrow_up = VK_UP,
		arrow_right = VK_RIGHT,
		arrow_down = VK_DOWN,
		insertkey = VK_INSERT,
		tabkey = VK_TAB,
		shiftkey = VK_SHIFT,
		controlkey = VK_CONTROL,
		optionkey = VK_MENU,
		commandkey = 0,
		spacebar = VK_SPACE,
		escapekey = VK_ESCAPE,
		pageupkey = VK_PRIOR,
		pagedownkey = VK_NEXT,
		homekey = VK_HOME,
		endkey = VK_END,
		backspacekey = VK_BACK,
		deletekey = VK_DELETE,
		helpkey = VK_F1			
	};	
	#else
	static enum 
	{	
		arrow_left = 123,
		arrow_up = 126,
		arrow_right = 124,
		arrow_down = 125,
		insertkey = 114,
		tabkey = 48,
		shiftkey = 56,
		controlkey = 59,
		optionkey = 58,
		commandkey = 55,
		spacebar = 49,
		escapekey = 53,
		pageupkey = 116,
		pagedownkey = 121,
		homekey = 115,
		endkey = 119,
		backspacekey = 51,
		deletekey = 117,
		helpkey = 122	
	};
	#endif
	
#ifdef WIN32
	inline int IsPressed(int k);
#else	
	inline int IsPressed(unsigned short k);
#endif
	
	KeyScanner(int *gc);
	~KeyScanner();
	Keys		Scan();
	void		Scan(unsigned long *flags);
	int 		TestPress();
	int			hPos, vPos;
	int			left()	{ return lastKeys & k_left; }
	int			right() { return lastKeys & k_right; }
	int			up()	{ return lastKeys & k_up; }
	int			down()	{ return lastKeys & k_down; }
	int			space();
	int			tab();
	int			ctrl()	{ return lastKeys & k_ctrl; }
	int			alt()	{ return lastKeys & k_alt; }
	int			esc();
	int			F1()	{ return lastKeys & k_help; }
	int			shift() { return lastKeys & k_shift; }
};

#endif
