/* Ping.cpp */

#define WIN32_EXTRA_LEAN
#include <windows.h>
#include <winsock.h>
#include <wsipx.h>
#include <conio.h>

#include "aes.h"

#define SERVER_SOCKET	0x3200

SOCKET g_skt;
BOOL g_serverUp;
AES *g_aesp;
AES::AESHandle g_hEvent;

void ServerThread(void *)
{
	if (!g_serverUp)
		return;

	fd_set rdSkts;
	FD_ZERO(&rdSkts);
	FD_SET(g_skt, &rdSkts);
	struct timeval tv = {5,0};
	int rval = select(0, &rdSkts, 0, 0, &tv);

	// schedule another pool thread to listen
	g_hEvent = g_aesp->ScheduleEvent(0, ServerThread, 0);

	// use this thread to process client request to completion
	if (rval < 0)
		printf("Winsock: select returned %d.\n", WSAGetLastError());
	else if (rval > 0)
	{
		SOCKADDR_IPX addr;
		int recvLen, addrLen = sizeof addr;
		char recvBuf[5];
		if ((recvLen = recvfrom(g_skt, recvBuf, sizeof recvBuf, 0,
				(struct sockaddr *)&addr, &addrLen)) == SOCKET_ERROR) 
		{
			printf("Winsock: recvfrom returned %d.\n", WSAGetLastError());
			return;
		}
		char *resp = strncmp(recvBuf, "Ping", 5)? "101 Invalid Request." : "Pong";
		int respLen = strlen(resp) + 1;
		if (sendto(g_skt, resp, respLen, 0, (struct sockaddr *)&addr, 
				sizeof addr) == SOCKET_ERROR)
			printf("Winsock: sendto returned %d.\n", WSAGetLastError());
	}
	return;
}

BOOL StartServer(WORD wSocket) 
{
	int err;
	SOCKADDR_IPX addr;
	WSADATA wsaData;

	if (!(g_aesp = new AES))
	{
		printf("Unable to create AES object.\n");
		return FALSE;
	}
	if (err = WSAStartup(MAKEWORD(1,1), &wsaData))
	{
		printf("WSAStartup returned %d.\n", err);
		goto errout1;
	}
	if (LOBYTE(wsaData.wVersion) < 1 || HIBYTE(wsaData.wVersion) < 1)
	{
		printf("Winsock version too low.\n");
		goto errout2;
	}
	if ((g_skt = socket(AF_IPX, SOCK_DGRAM, NSPROTO_IPX)) == INVALID_SOCKET)
	{
		printf("Windsock: socket returned %d.\n", WSAGetLastError());
		goto errout2;
	}
	memset(&addr, 0, sizeof(SOCKADDR_IPX));
	addr.sa_family = AF_IPX;
	addr.sa_socket = htons(wSocket);
	if (bind(g_skt, (struct sockaddr *) &addr, sizeof(SOCKADDR_IPX)) != 0)
	{
		printf("Winsock: bind returned %d.\n", WSAGetLastError());
		goto errout3;
	}
	g_serverUp = TRUE;
	if (!(g_hEvent = g_aesp->ScheduleEvent(0, ServerThread, 0)))
	{
		printf("AES: Unable to schedule event.\n");
		g_serverUp = FALSE;
		goto errout3;
	}
	return TRUE;

errout3:
	closesocket(g_skt);
errout2:
	WSACleanup();
errout1:
	delete g_aesp;
	return FALSE;
}

void StopServer(void) 
{
	g_serverUp = FALSE;
	g_aesp->CancelEvent(g_hEvent);
	delete g_aesp;
	closesocket(g_skt);
	WSACleanup();
	return;
}

void main(void)
{
	if (StartServer(SERVER_SOCKET))
	{
		printf("Server running, press any key to terminate...\n");
		getch();
		StopServer();
	}
	printf("Server terminated, press any key to exit...\n");
	getch();
	return;
}

