// texture.h

#include "WinDOS.h"
#include "Color16.h"

class Texture16 {
	char 			*bits;
	short			*pairs;
	int				width, height, rowBytes;
public:
					Texture16(int w, int h) : width(w), height(h) { 
						rowBytes = width * 2;
						bits = new char[height * rowBytes];
						pairs = (short*)bits; }
					~Texture16() { Clear(); }
	void			Clear() { if (bits) delete [] bits; bits = NULL; pairs = NULL; }				
					
	char			*CreateWashLR(Rgb start, Rgb end);
	char			*CreateWashTB(Rgb start, Rgb end);
	char			*CreateFlatColor(Rgb col);	
	char			*CreateBlock(Rgb col);		
};