#ifndef QUAD3D_H
#define QUAD3D_H

#include "Vector3D.h"

enum {
	QUAD_FIXED = 0,
	QUAD_MOVEABLE = 1,
	QUAD_LEFTHAND = 2 // right is default (QD3D, Renderware etc; D3D is left handed)
};

class Quad3D {
public:
	static float light_res;
	int 		vi1, vi2, vi3, vi4;			// vertex indices
	Uv 			uv1, uv2, uv3, uv4;			// texture coords
	Rgb			rgb1, rgb2, rgb3, rgb4;		// vertex gouraud values
	long		userData;
	
	// Viewport-clipped values
	Uv 			clip_uv1, clip_uv2, clip_uv3, clip_uv4;				
	Rgb			clip_rgb1, clip_rgb2, clip_rgb3, clip_rgb4;			

	float		r, g, b;					// base values
	int 		texmap; 					// index into renderer-specific texture map
	int			type; 						// fixed, moveable etc for dynamic or static lighting
	Vector3D 	normal;
	class 		Quad3D *next;
	float		lightEffect_1, lightEffect_2, lightEffect_3, lightEffect_4;
	float		light_distance, light_strength; // for default light (lightList[0])
	Vertex3D 	clip_v[4]; 						// The clipped vertices (passed to TimeSlice)
	
				Quad3D(
					int ivi1, int ivi2, int ivi3, int ivi4,
					Uv &puv1, Uv &puv2, Uv &puv3, Uv &puv4, Rgb &p_rgb,
					int texmapIndex, int ptype, 
					Light3D light_list[],
					Vector3D vertex_list[], long ud);					
					
	void 		CalcFixedLightEffects(
					Light3D lightList[], 
					Vertex3D &v1, Vertex3D &v2, Vertex3D &v3, Vertex3D &v4);
	int 		GetClip(Vertex3D *vertexList);				
};

#endif