// MCutils

#include "MCutils.h"

static int MAX_STRING_SEARCH = 32767;

void SetMaxStringSearch(int i)
{
	MAX_STRING_SEARCH = i;	
}

int LoadLocal2Buffer(char *filename, char **buffH)
{
	return LoadFile2Buffer(filename, buffH);
}

static int LoadFile2Buffer(char *completepath, char **buffH)
{
	FILE *fp;
	char *buff;	
	int siz;
	*buffH = NULL;
	if (completepath) {
		fp = fopen(completepath, "r");
		if (fp) {
			siz = FileSize(fp);
			if (siz < 1) {
				fclose(fp);
				return 0;
			}
			buff = new char[siz + 1];
			if (!buff) {
				fclose(fp);
				return 0;
			}
			fread(buff, siz, 1, fp);
			buff[siz] = 0;			
			fclose(fp);
			*buffH = buff;
			return siz;
		}
		else {
			fp = fopen(completepath, "w");
			if (fp) { 
				fprintf(fp, "comment = \"Generic config file by Heads Off.\"");
				fclose(fp);				
			}		
		}		
	}			
	return 0;
}

char *ReadNextLine(char *start, char line[], int linebuffsize) 
// make sure you have enough allocated in line!
// if you pass NULL for line, it means you're not interested
// in the string itself, but the pointer to it
{
	char *ptr = start;
	int count = 0, transferred_amount;
	while (*ptr == 0x0A || *ptr == 0x0D)
		ptr++; // trim any junk at head
	if (!*ptr) {
		if (line)
			*line = 0;
		return NULL;
	}		
	while (*ptr != 0x0A && *ptr) {
		ptr++;
		if (++count >= MAX_STRING_SEARCH)
			return NULL;
	}	
	if (line) {
		transferred_amount = count > linebuffsize ? linebuffsize : count;
		memcpy(line, start, transferred_amount);
		line[transferred_amount] = 0;
	}
	if (*ptr)
		return ++ptr; // return a pointer to the next line
	else
		return NULL; // finished
} 
	