// MCFile.h

// file Utilities - Mark Carolan 1995

#pragma once

#ifdef WIN32
#include <windows.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif 

#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#define MAXFILE		64
#define MAXPATH		255
#define ALERTID 	128

// convert reals 0.0 - 1.0 to more readable int 1-100
#define	SHOWASINT(realNum)	REAL2INT(RMul(realNum, CREAL(100.0)))
#define READASINT(entryNum) FL2REAL((float)entryNum/100.0)

// Renderware info
#define BYTETOREAL(v) (RDiv(INT2REAL((RwInt32)(v)), CREAL(255.0)))
#define REALTOBYTE(r) ((int)(REAL2INT(RMul((r), CREAL(255.0)))))
#define LIGHT_IDENTIFIER '*'
#define INTERNAL_IDENTIFIER '>'
#define STATIC_INTERNAL_IDENTIFIER '('
#define opacity_filter 0x64000000
#define color_filter 0x00FFFFFF
#define default_light_setting 0x64FEFEFE
#define red_filter 0x00FF0000
#define green_filter 0x0000FF00
#define blue_filter 0x000000FF
#define ClearBit(data, xflag) data &= (0xFFFFFFFF ^ xflag)
#define SetBit(data, xflag) data |= xflag
#define IsBit(data, nFlag) data & nFlag 
#define PlusMinusRand(var) rand() % (var * 2) - var
#define NOCLUMP -1

#define SubtractAddresses(addr, sub) (char*)addr - (char*sub)
#define AddToAddress(addr, num) (char*)addr += num
#define AddAddresses(addr1, addr2) (char*)addr1 + (char*)addr2 

#define OKDOS(c) 	((c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z') ||\
					 (c >= '0' && c <= '9') || (c == '_'))\
					 ? 1 : 0

#define TAB(s, tabber)		while (*s++ != tabber)

short CharToNum( char * str );
unsigned long CharToULongNum( char * str );
short CompareStr( char* subStr, char * mainStr );
short CompareStrCaseless( const char* subStr, const char * mainStr );
void CopyStr( char to[], const char from[] );
void UpperStr( char *str );
long Pow( long base, short n );
short StrLen( const char * str );
void SubStr(char *c, char *sub, int n);
void LastInPath(char *fullPath, char *shortStuff);
void MakeUnique(char *prev, char *thisOne);
void NumTo3Digits(int num, char *pbuf);
int TabbedStrlen(char *c, char tab);
void StrCat(char *dest, char *src);
int StripNonDOS(char *cstr);
int TabbedStrcmp(char *s1, char *s2, char tab);
long Pow( long base, short n );
void UpperStr( char *str );
void CopyStr( char to[], const char from[] );
short CompareStrCaseless( const char* subStr, const char * mainStr );
short CompareStr( char* subStr, char * mainStr );
unsigned long CharToULongNum( char * str );
inline char UpperChar(char c) { return (c > 'Z') ? c - ('a' - 'A') : c;}
short CharToNum( char * str );
short StrLen( const char * str );
void SubStr(char *c, char *sub, int n);
void LastInPath(char *fullPath, char *shortStuff);
void MakeUnique(char *prev, char *thisOne);
int TabbedStrlen(char *c, char tab);
int TabbedStrcmp(char *s1, char *s2, char tab);
int GetRecordLength(void *buff);
int DemoTimedOut(int year, int month, int day);
#ifdef MAC
void inf(char *text);
#else
void inf(char *txt);
#endif

#ifdef __cplusplus
}
#endif 