// File: SGIReader.h
//
// (c) 1996 Mayur Patel

#ifndef SGIReader_CLASS
#define SGIReader_CLASS

#include <SampledImage.h>
#include <BinaryBuffer.h>
#include <fstream.h>

// *******************************************************************
// CLASS : SGIReader
// DESCRIPTION:
//    Provides Support for SGI RGB format image files as per
//    version 1.0 of the specification.
//
class SGIReader : public SampledImage {
   public:
      enum Status {
         OK = 0,
         BadFilename,
         BadSGIFormat,
         RAMError,
         UnsupportedFeature,
         FileError
      };
         
   public:
      SGIReader( const char *cpFilename ); 
      ~SGIReader( void ); // close
      
      int
      fillTile( ImageTile *pWriteHere );
      
      Status
      getStatus( void ) const
      { return ( _status ); }
      
   protected:
      int		_isRLE;
      Status		_status;
      ifstream		_fileStream;

      unsigned long	_lMax;
      unsigned long	_lMin;
      
      BinaryBuffer	_startTable;
      BinaryBuffer	_lengthTable;
      
      // 2 chars -> 1 short
      unsigned short
      castToShort( unsigned char *cp );
      
      // 4 chars -> 1 long
      unsigned long
      castToLong( unsigned char *cp );
      
      int
      seekRow( int iRow, int iChannel );
      
      void
      readRow( void *pDest, int iRow, int iChannel );
      
      void
      _decode8( unsigned char  *cp );
      
      void
      _decode16( unsigned short *sp );
};

#endif
