//: FileTime.h
#if !defined(FILETIME_H_)
#define FILETIME_H_
#include <stdexcept>
#include <windows.h>

#if defined(__BORLANDC__)
 using namespace std;
#endif

class FileTime {
 WORD mYear;
 WORD mMonth;  // January = 1
 WORD mDayOfWeek; // Sunday = 0
 WORD mDay;
 WORD mHour;
 WORD mMinute;
 WORD mSecond;
 WORD mMillisecond; // 0-999
 enum { 
  DateLength=10, TimeLength=12, YearLength=4, MonthLength=2,
        DayOfWeekLength=9,DayLength=2,HourLength=2, MinuteLength=2,
  SecondLength=2, MillisecondLength=3, MaxLength=13 };
 char mString[MaxLength];
 char mDateSeparator;
 char mTimeSeparator;
 char mDateFillCharacter;
 char mTimeFillCharacter;
 void ZeroMemberVars() throw();
public:
 inline FileTime() throw() { ZeroMemberVars();   }
    inline FileTime(const FILETIME *pFileTime) throw(runtime_error){
  NewTime(pFileTime); }

 // Sets this object's time to the new time
 void NewTime(const FILETIME *pFileTime) throw(runtime_error);
 // The Separator and Fill characters only affect the strings
 // returned by the various String() functions.
 inline void DateSeparator(const char NewSeparator) throw() {
  mDateSeparator=NewSeparator; }
 inline void TimeSeparator(const char NewSeparator) throw() {
  mTimeSeparator=NewSeparator; }
 inline void DateFill(const char NewFill)   throw() {
  mDateFillCharacter=NewFill;  }
 inline void TimeFill(const char NewFill)   throw() {
  mTimeFillCharacter=NewFill;  }

 // Get functions
    inline WORD Year()          const throw() {return mYear;       }
    inline WORD Month()         const throw() {return mMonth;      }
    inline WORD DayOfWeek()     const throw() {return mDayOfWeek;  }
    inline WORD Day()           const throw() {return mDay;        }
    inline WORD Hour()          const throw() {return mHour;       }
    inline WORD Minute()        const throw() {return mMinute;     }
    inline WORD Second()        const throw() {return mSecond;     }
    inline WORD Millisecond()   const throw() {return mMillisecond;}
 
   inline char DateSeparator() const throw(){return mDateSeparator;}
   inline char TimeSeparator() const throw(){return mTimeSeparator;}
   inline char DateFill() const throw() {return mDateFillCharacter;}
   inline char TimeFill() const throw() {return mTimeFillCharacter;}

 const char* const DateString()       throw();
 const char* const TimeString()       throw();
 const char* const YearString()        throw();
 const char* const MonthString()       throw();
 const char* const DayOfWeekString()   throw();
 const char* const DayString()         throw();
 const char* const HourString()        throw();
 const char* const MinuteString()      throw();
 const char* const SecondString()      throw();
 const char* const MillisecondString() throw();
};
#endif // FILETIME_H_
