[Caption: Listing 4 - Socket I/O functions]


#include <stdio.h>
#include <string.h>

#define MAXBUF 512

/*
   ----------------- recvStr -----------------
   
   read a newline-terminated string from a
   stream socket descriptor
   
*/

int recvStr(int fd, char *cptr, int *len)
{
  int i, n;
  
  *len = 0;
  i = 0;
  
  while (1)
  { if (i == MAXBUF-1)
    { fprintf(stderr,
        "*Warning - input buffer overflow\n");
      break;
    }
    n = read(fd, cptr+i, 1);
    if (n < 0)
    { perror("read");
      return(0);
    }
    else if (n == 0)
    { cptr[i] = '\0';
      *len = i;
      return(0);         /* EOF */
    }
    else if (cptr[i] == '\r')
      /* watch for cr-lf */
      continue;
    else if (cptr[i] == '\n')
      break;
    i++;
  }
  cptr[i] = '\0';
  *len = i;
  return(1);
}

/*
   ------------------ sendStr ----------------
   
   write an asciiz string to a stream socket
   descriptor
   return 0 on error

*/

int sendStr(int fd, char *cptr)
{
    if (write(fd, cptr, strlen(cptr)) < 0)
    { perror("write");
      return (0);
    }
  return(1);
}
