#include <afxwin.h>				// MFC core and standard components.
#include <afxext.h>				// MFC Extensions.
#include <iostream.h>
#include <string.h>
#include "CWinCGI.h"
#include "CWinCGITuple.h"
#include "CWinCGIFileTuple.h"
#include "CWinCGIHugeTuple.h"

// ======================================================================
//
// Class Constructor for CWinCGI
//
// ======================================================================
CWinCGI::CWinCGI() : CGI_AcceptTypes(NULL),	CGI_ExtraHeaders(NULL), 
                     CGI_FormTuples(NULL), CGI_HugeTuples(NULL), 
					 CGI_FileTuples(NULL)
{	
	// ------------------
	// HTTP Header Arrays
	// ------------------
	CGI_AcceptTypes = new Tuple [MAX_ACCTYPE];				// Accept: types
	CGI_ExtraHeaders = new Tuple [MAX_XHDR];				// "Extra" headers

	// --------------
	// POST Form Data
	// --------------
	CGI_FormTuples = new Tuple [MAX_FORM_TUPLES];			// POST form "key=value" pairs
	CGI_HugeTuples = new HugeTuple [MAX_HUGE_TUPLES];		// Form "huge" tuples
	CGI_FileTuples = new FileTuple [MAX_FILE_TUPLES];		// File upload tuples
}

// =====================================================================
// 
// Class Destructor for CWinCGI
//
// =====================================================================
CWinCGI::~CWinCGI()
{
	delete [] CGI_AcceptTypes;					// Accept: types
	delete [] CGI_ExtraHeaders;					// "Extra" headers

	// --------------
	// POST Form Data
	// --------------
	delete [] CGI_FormTuples;					// POST form "key=value" pairs
	delete [] CGI_HugeTuples;					// Form "huge" tuples
	delete [] CGI_FileTuples;					// File upload tuples

}
//----------------------------------------------------------------------
//
// Return True/False depending on whether a form field is present.
//
//----------------------------------------------------------------------
BOOL CWinCGI::FieldPresent(CString &key)
{
    int i;

    for (i=0; i<= (CGI_NumFormTuples - 1); i++)
    {
	  if(CGI_FormTuples[i].key == key)
	  {
		return TRUE;										// leave function.
      }
    }
	return FALSE;
}

//----------------------------------------------------------------------
//
// Get the value of a "small" form field given the key
//
// Throws an error if field does not exist
//
//----------------------------------------------------------------------
CString CWinCGI::GetSmallField(CString &key)
{
	long i;

	for (i = 0; i <= (CGI_NumFormTuples - 1); i++)
	{
	if (CGI_FormTuples[i].key == key)
		{
			CGI_FormTuples[i].value.TrimLeft;
			CGI_FormTuples[i].value.TrimRight;
			return CGI_FormTuples[i].value;
		}
	}
	throw ERR_NO_FIELD;		// Field was not found in the .INI file
	return "";
}

//---------------------------------------------------------------------------
//
//   InitializeCGI() - Fill in all of the CGI variables.
//
// Read the profile file name from the command line, then fill in
// the CGI s, the Accept type list and the Extra headers list. Then
// open the output file.
//
//---------------------------------------------------------------------------
void CWinCGI::InitializeCGI(int argc, char *argv[])
{
    char *sect;
    CString buf;

    CGI_DebugMode = 0;

    CGI_ProfileFile = argv[1];

    sect = "CGI";
    CGI_ServerSoftware = GetProfile(sect, CString("Server Software"));
    CGI_ServerName = GetProfile(sect, CString("Server Name"));
    CGI_RequestProtocol = GetProfile(sect, CString("Request Protocol"));
    CGI_ServerAdmin = GetProfile(sect, CString("Server Admin"));
    CGI_Version = GetProfile(sect, CString("CGI Version"));
    CGI_RequestMethod = GetProfile(sect, CString("Request Method"));
    buf = GetProfile(sect, CString("Request Keep-Alive"));	// Y or N

    if (buf.Left(1) == "Y")					// Must start with Y
	  CGI_RequestKeepAlive = TRUE;
    else
        CGI_RequestKeepAlive = FALSE;
    
    CGI_LogicalPath = GetProfile(sect, CString("Logical Path"));
    CGI_PhysicalPath = GetProfile(sect, CString("Physical Path"));
    CGI_ExecutablePath = GetProfile(sect, CString("Executable Path"));
    CGI_QueryString = GetProfile(sect, CString("Query String"));
    CGI_RemoteHost = GetProfile(sect, CString("Remote Host"));
    CGI_RemoteAddr = GetProfile(sect, CString("Remote Address"));
    CGI_RequestRange = GetProfile(sect, CString("Request Range"));
    CGI_Referer = GetProfile(sect, CString("Referer"));
    CGI_From = GetProfile(sect, CString("From"));
    CGI_UserAgent = GetProfile(sect, CString("User Agent"));
    CGI_AuthUser = GetProfile(sect, CString("Authenticated Username"));
    CGI_AuthPass = GetProfile(sect, CString("Authenticated Password"));
    CGI_AuthRealm = GetProfile(sect, CString("Authentication Realm"));
    CGI_AuthType = GetProfile(sect, CString("Authentication Method"));
    CGI_ContentType = GetProfile(sect, CString("Content Type"));
    buf = GetProfile(sect, CString("Content Length"));

    if (buf == "")
        CGI_ContentLength = 0;
    else
        CGI_ContentLength = atol(buf);
	
    buf = GetProfile(sect, CString("Server Port"));
    if (buf == "")
   	   CGI_ServerPort = -1;
    else
       CGI_ServerPort = atol(buf);
	
    sect = "System";
    CGI_ContentFile = GetProfile(sect, CString("Content File"));		// *.inp
    CGI_OutputFile = GetProfile(sect, CString("Output File"));			// *.out

    /* Open CGI_OutPut file for write */
    if( !CGI_OutFile.Open( CGI_OutputFile, CFile::modeWrite|CFile::modeCreate) )
      throw CGI_CANT_OPEN_OUT_FILE;
    
	CTime mytime;
	CGI_GMTOffset = mytime.GetLocalTm( NULL ) - mytime.GetGmtTm( NULL );
	
	buf = GetProfile(sect, CString("Debug Mode"));						// Y or N
	if (buf.Left(1) == "Y")										// Must start with Y
		CGI_DebugMode = TRUE;
	else
		CGI_DebugMode = FALSE;
	    
		GetAcceptTypes();						// Enumerate Accept: types into tuples
		GetExtraHeaders();						// Enumerate extra headers into tuples
		GetFormTuples();						// Decode any POST form input into tuples
}

//----------------------------------------------------------------------
//
//  Send() - Used for writing to the output file
//
//----------------------------------------------------------------------
void CWinCGI::Send(CString &s)
{
	CGI_OutFile.WriteString(s+"\n");
}

//---------------------------------------------------------------------------
//
//   SendNoOp() - Send back only standard headers and a blank line.
//
//---------------------------------------------------------------------------
void CWinCGI::SendNoOp()
{
	CString tmpCString;

	Send (CString("HTTP/1.0 204 No Response"));
	tmpCString = CString("Server: ") + CGI_ServerSoftware;
    Send (tmpCString);
    Send (CString(""));
}
	
//---------------------------------------------------------------------------
//
//   GetAcceptTypes() - Create the array of accept type structs
//
// Enumerate the keys in the [Accept] section of the profile file,
// then get the value for each of the keys.
//---------------------------------------------------------------------------
void CWinCGI::GetAcceptTypes()
{
	CString sList;
	CString sKey;
	long i, j, l, n;

	sKey.Empty;
	sList = GetProfile("Accept", sKey);						// Get key list
	l = sList.GetLength();									// Length incl. trailing null
	i = 0;													// Start at 1st character
	n = 0;													// Index in array
	while ((i < (l-1)) && (n < MAX_ACCTYPE))				// Safety stop here (L not one)
	{
	  j = i + (sList.Mid(i)).Find('\255');					// j -> next \255 character;
	  CGI_AcceptTypes[n].key = sList.Mid(i, j - i);			// Get Key, then value
	  CGI_AcceptTypes[n].value = GetProfile("Accept", CGI_AcceptTypes[n].key);
	  i = j + 1;											// Bump pointer
	  n++;													// Bump array index
	}	
	CGI_NumAcceptTypes = n;									// Fill in  count
}

//---------------------------------------------------------------------------
//
//   GetExtraHeaders() - Create the array of extra header structs
//
// Enumerate the keys in the [Extra Headers] section of the profile file,
// then get the value for each of the keys.
//---------------------------------------------------------------------------
void CWinCGI::GetExtraHeaders()
{
	CString sList;
	CString sKey;
	long i, j, l, n;
	
	sKey.Empty;
	sList = GetProfile("Extra Headers", sKey);			// Get key list
	l = sList.GetLength();								// Length incl. trailing null
	i = 0;												// Start at 1st character
	n = 0;												// Index in array
	while ((i < l) && (n < MAX_XHDR))					// Safety stop here
	{
		j = i + (sList.Mid(i)).Find('\255');			// locate the next \255 character
		CGI_ExtraHeaders[n].key = sList.Mid(i, j - i); 	// Get Key, then value
		CGI_ExtraHeaders[n].value = GetProfile("Extra Headers", CGI_ExtraHeaders[n].key);
		i = j + 1;										// Bump pointer
		n++;											// Bump array index
	}
	CGI_NumExtraHeaders = n;							// Fill in  count
}

//---------------------------------------------------------------------------
//
//   GetFormTuples() - Create the array of POST form input key=value pairs
//
//---------------------------------------------------------------------------
void CWinCGI::GetFormTuples()
{
	CString sList;
	long i, j, k, l, n;
	CString buf;
	CString extName;
	CFile extFile;
	long extlen;
	CString sKey;

	//
	// The [Form Literal] section.
	//

	sKey.Empty();
	sList = GetProfile("Form Literal", sKey);					// Get key list
	l = sList.GetLength();										// Length incl. trailing null
	i = 0;														// Start at 1st character
	n = 0;														// Index in array
	while ((i < l) && (n < MAX_FORM_TUPLES))
	{
		j = i + (sList.Mid(i)).Find('\255');					// j -> next \255 character
		CGI_FormTuples[n].key = sList.Mid(i, j - i);			// Get Key, then value
		CGI_FormTuples[n].value = GetProfile("Form Literal", CGI_FormTuples[n].key);
		i = j + 1;
		n++;
	}

	// 	The [Form External] section
	sKey.Empty();
	sList = GetProfile("Form External", sKey);					// Get key list
	l = sList.GetLength();										// Length incl. trailing null
	i = 0;														// Start at 1st character
	while ((i < l) && (n < MAX_FORM_TUPLES))
	{
		j = i + (sList.Mid(i)).Find('\255');					// j -> next \255 character
		CGI_FormTuples[n].key = sList.Mid(i, j - i);			// Get Key, then pathname
		buf = GetProfile("Form External", CGI_FormTuples[n].key);
		k = buf.Find(" ");										// Split file & length
		extName = buf.Mid(0, k);								// Put filename into variable
		k++;
		extlen = atol(buf.Mid(k));								// Length - start at position k to end
		if( !extFile.Open( extName, CFile::modeRead | CFile::typeBinary) )
			throw CGI_FORM_EXTERNAL_ERROR;
		char *pextFile = new char[extlen+1];					// Pointer with just enough allocated
		extFile.Read(pextFile, extlen);							// Read in the data
		pextFile[extlen] = NULL;								// The string MUST end with a NULL.
		CGI_FormTuples[n].value = pextFile;						// Put data from file into CString var.
		delete [] pextFile;
		extFile.Close;
		i = j + 1;
		n++;
	}
		CGI_NumFormTuples = n;									// Number of fields decoded

	// 		The [Form Huge] section.
	sKey.Empty;
	sList = GetProfile("Form Huge", sKey);						// Get key list
	l = sList.GetLength();										// Length incl. trailing null
	i = 0;														// Start at 1st character
	n = 0;														// Reset counter
	while ((i < l) && (n < MAX_FORM_TUPLES))
	{
		j = i + sList.Mid(i).Find('\255');						// j -> next \255 character
		CGI_HugeTuples[n].key = sList.Mid(i, j - i);			// Get Key
		buf = GetProfile("Form Huge", CGI_HugeTuples[n].key);	// Get the "offset length"
		k = buf.Find(" ");										
		CGI_HugeTuples[n].offset = atol(buf.Mid(1, (k - 1)));
		CGI_HugeTuples[n].length = atol(buf.Mid(k, (buf.GetLength() - k + 1)));
		i = j + 1;
		n++;
	}
    	CGI_NumHugeTuples = n;									// Fill in count
	
	//
	// The [Form File] section.
	//
	sKey.Empty;
	sList = GetProfile("Form File", sKey);						// Get key list
	l = sList.GetLength();
	i = 0;														// Start at 1st character
	n = 0;														// Reset counter
	while ((i < l) && (n < MAX_FILE_TUPLES))
	{
		j = i + sList.Mid(i).Find('\255');						// j -> next \255 character
		CGI_FileTuples[n].key = sList.Mid(i, j - i);			// Get Key
		buf = GetProfile("Form File", CGI_FileTuples[n].key);
		ParseFileValue(buf, CGI_FileTuples[n]);
		i = j + 1;
		n++;
	}
    	CGI_NumFileTuples = n;									// Fill in  count
}

//---------------------------------------------------------------------------
//
//   GetProfile() - Get a value or enumerate keys in CGI_Profile file
//
//---------------------------------------------------------------------------
CString CWinCGI::GetProfile(char *sSection, CString &sKey)
{
    long retLen;
	long i;
    char buf[ENUM_BUF_SIZE];
	const char separator = '\255';
	CString bufstring;
	
    if (!sKey.IsEmpty())
        retLen = GetPrivateProfileString(sSection, sKey, "", buf, ENUM_BUF_SIZE, CGI_ProfileFile);
    else
	{
        retLen = GetPrivateProfileString(sSection, NULL, "", buf, ENUM_BUF_SIZE, CGI_ProfileFile);
		// Because we are using CStrings, we need to convert NULL to \255 to get
		// all of the information back up to the calling routine.
		i=0;
		while (i < retLen)
		{
			if (buf[i] == NULL)
				buf[i] = separator;
			i++;
		}
	}

	    
    if (retLen == 0)
        return "";
    else
		bufstring = buf;
        return bufstring;
}
	
//----------------------------------------------------------------------------
//
//  ParseFileValue() 
//
//----------------------------------------------------------------------------
void CWinCGI::ParseFileValue(CString &buf, FileTuple tmp)
{
	long i, j, l;
    
	l = buf.GetLength();
    
	i = buf.Find(" ");											// First delimiter
	tmp.file = buf.Mid(1, (i - 1));								// [file]
	tmp.file = tmp.file.Mid(2, tmp.file.GetLength() - 2);		// file
	
	j = i + (buf.Mid(i+1)).Find(" ");							// Next delimiter
	tmp.length = atol(buf.Mid((i+1), (j - i - 1)));
	i = j;
	
	j = i + (buf.Mid(i+1)).Find(" ");							// Next delimiter
	tmp.type = buf.Mid((i+1), (j - i - 1));
	i = j;
	
	j = i + (buf.Mid(i+1)).Find(" ");							// Next delimiter
	tmp.encoding = buf.Mid((i+1), (j - i - 1));
	i = j;
	
	tmp.name = buf.Mid((i + 1), (l - i - 1));
	tmp.name = tmp.name.Mid(2, (tmp.name.GetLength()) - 1);
}

//---------------------------------------------------------------------------
//
//   FindExtraHeader() - Get the text from an "extra" header
//
// Given the extra header's name, return the stuff after the ":"
// or an empty string if not there.
//---------------------------------------------------------------------------
CString CWinCGI::FindExtraHeader(CString &key)
{
	long i;

	for (i = 0; i <= (CGI_NumExtraHeaders - 1); i++)
	{
		if (CGI_ExtraHeaders[i].key == key)
		{
			CGI_ExtraHeaders[i].value.TrimRight();
			CGI_ExtraHeaders[i].value.TrimLeft();
			return CGI_ExtraHeaders[i].value;			// ** DONE **
		}
	}
    return "";						// Not present, return empty string
}

//---------------------------------------------------------------------------
//
// errorhandler() -  error handler
//
// If a runtime error occurs dusing execution of the program, this
// procedure generates an HTTP/1.0 HTML-formatted error message into
// the output file, then exits the program.
//
//---------------------------------------------------------------------------
void CWinCGI::errorhandler(int error_code)
{
	char tmp[5];
	CString DateAndTime;

	CGI_OutFile.SeekToBegin();	// Remove previously written stuff and
								// place this error message in the output file.
	Send(CString("HTTP/1.0 500 Internal Error"));
	Send(CString(strcat("Server: ", CGI_ServerSoftware)));
	CTime t = CTime::GetCurrentTime();
	DateAndTime = CString("Date: ") + t.Format( "%A, %B %d, %Y" );
	Send(DateAndTime);
	Send(CString("Content-type: text/html"));
	Send(CString(""));
	Send(CString(""));
	Send(CString("<HTML><HEAD>"));
	Send(CString(strcat(strcat("<TITLE>Error in ", CGI_ExecutablePath), "</TITLE>")));
	Send(CString("</HEAD><BODY>"));
	Send(CString(strcat(strcat("<H1>Error in ", CGI_ExecutablePath), "</H1>")));
	_itoa(error_code, tmp, 10);
	Send(CString(strcat(strcat("<PRE> with code :", tmp), "</PRE>")));
	Send(CString(strcat(strcat("An internal error has occurred in ", CGI_ExecutablePath), ".")));
	Send(CString("Administrator of this service: "));
	Send(CString(strcat(strcat("<A HREF=\"mailto:", CGI_ServerAdmin), "\">")));
	Send(CString(strcat(strcat("<ADDRESS>&lt;", CGI_ServerAdmin), "&gt;</ADDRESS>")));
	Send(CString("</A></BODY></HTML>"));
	CGI_OutFile.Close();
	exit;									// Terminate the program here and NOW!
}