[Caption: Listing 1 -- webhead main program]

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

void getURL(char **argv, char *hostName,
            char *resource, int *httpPort);
int openSock(char *hostName, int httpPort);
int recvStr(int fd, char *cptr, int *len);
int sendStr(int fd, char *cptr);

main(int argc, char **argv)
{
  char buf[512];
  char hostName[512];
  char resource[512];
  int skt;
  int cont;
  int len;
  int state;
  int rc;
  char *cp;
  int httpPort = 80;

  if (argc < 2)
  { fprintf(stderr, "Usage: %s URL\n", argv[0]);
    exit(0);
  }

  getURL(argv, hostName, resource, &httpPort);
  skt = openSock(hostName, httpPort);

  /* send message to server - note CRLF line termination */
  sprintf(buf, "GET %s HTTP/1.0\r\n",resource);
  sendStr(skt, buf);
  sprintf(buf, "\r\n");
  sendStr(skt, buf);

  /* read and print response */
  cont = 1;
  state = 0;
  while (cont && recvStr(skt, buf, &len))
  { switch (state)
    { case 0: printf("%s\n",buf);          /* initial state */
              sscanf(buf, "%*s %d", &rc);
              if (rc >= 300)
                state = 1;
              else
                state = 2;
              break;
      case 1: printf("%s\n",buf);          /* error condition */
              break;
      case 2: printf("%s\n",buf);          /* OK - getting header */
              if (len == 0)
                state = 3;
              break;
      case 4:
      case 3: cp = strtok(buf, "< \t");  /* OK - search for title */
              while (cp)
              { if (!strncasecmp(cp, "title>", 6))
                { state = 4;
                  printf("TITLE: %s ",cp+6);
                }
                else if (!strncasecmp(cp, "/title>", 7) ||
                         !strncasecmp(cp, "/head>", 6)  ||
                         !strncasecmp(cp, "body>", 5))
                { cont = 0;
                  break;
                }
                else if (state == 4)
                  printf("%s ", cp);
                cp = strtok(NULL, "< \t");
              }
              break;
    }
  }
  printf("\n");

  close(skt);
}






























