[Caption: Listing 2 -- Implementation of a few typical SegmentStream methods]

// Create a packet stream, and tell the link layer
// we're starting a packet
SegmentOutStream::SegmentOutStream(LAPOut& _out_link)
  : out_link(_out_link)
{
  out_link.begin_packet();
}

// write the CRC and flush the packet to the link
SegmentOutStream::~SegmentOutStream(void)
{
  out_link << crc;
  out_link.finish_packet();
}

// All multi-byte quantities are written in the MSB first
// byte order
inline SegmentOutStream&
SegmentOutStream::operator << (const unsigned short a_short)
{
  write_byte(a_short>>8);
  write_byte(a_short);
  return *this;
}

SegmentOutStream&
SegmentOutStream::operator << (const Array& array)
{
  assert( array.size < Segment0::max_MTU );
  assert( array.size > 0 );
  for(register const char * p = array.ptr;
      p < array.ptr + array.size; )
    write_byte(*p++);
  return *this;
}
