//: PrintWalk with time
#include <iostream>
#include <stdexcept>
#include "DirWalk.h"

class PrintWalk : public DirWalk {
public:
 inline PrintWalk() throw() : DirWalk() {}
 inline virtual void FoundFile() {
        //indent according to recursion depth
  for(int i=0;i < Depth();i++) cout << "   ";
  if(mFA.IsDirectory()) {
            cout << "[" << Filename() << "]";
  } else {
            cout << Filename();            
  }
        cout << '\t';
        cout << mLastWriteTime.DateString();
        cout << '\t';
        cout << mLastWriteTime.TimeString();
  cout << endl;
 }
};

int main() {
 PrintWalk pw;
 try {
  pw.Walk();
 } catch(exception& e) {
  cout << e.what() << endl;
  return 1;
 } catch(...) {
  return 1;
 }
 return 0;
}

