//: PowerWalk example
#include <iostream>
#include <stdexcept>
#include <vector>
#include "DirWalk.h"

class PowerWalk : public DirWalk {
#if defined(_MSC_VER)
 vector<string, allocator<string> > Files_;
#else
 vector<string> Files_;
#endif
public:
 inline PowerWalk() throw() : DirWalk(TRUE,FALSE) {}
 inline virtual void FoundFile() {
  char FullPathBuf[_MAX_PATH];
  LPTSTR dummy;
  if(GetFullPathName(Filename(),_MAX_PATH,FullPathBuf,&dummy))
   Files_.push_back(string(FullPathBuf));
  else
   Files_.push_back(string(Filename()));
 }
 inline void PrintFiles() throw() {
#if defined(_MSC_VER)
  vector<string, allocator<string> >::iterator i;
#else
  vector<string>::iterator i;
#endif
  for(i=Files_.begin();i!=Files_.end();i++)
   cout << (*i).c_str() << endl;
 }
};

int main() {
 PowerWalk pw;
 try {
  pw.Walk();
  pw.PrintFiles();
 } catch(exception& e) {
  cout << e.what() << endl;
  return 1;
 } catch(...) {
  return 1;
 }
 return 0;
}
