#ifndef CWinCGI_H
#define CWinCGI_H

/*----------------------------------------------------------------------------
MICROSOFT VISUAL C++ Implementation for WinCGI applications
VERSION: 1.0  (August 28, 1996)

This work is a conversion to Microsoft Visual C++ by Mark Wheeler
from Bob Denny's Visual Basic version to allow Visual C++ applications 
to be utilized as server applications in a WinCGI environment.  Most
of the comments remained unchanged with the exception of those
that were particular to VB.
 
Webservers that support WinCGI, execute script requests by doing 
a CreateProcess with a command line in the following form:

   prog-name cgi-profile

 THE CGI-PROFILE FILE

 The Unix CGI passes data to the back end by defining environment
 variables which can be used by shell scripts. The WinCGI enabled
 servers pass data to its back end via the profile file. The
 format of the profile is that of a Windows ".INI" file.

 There are 7 sections in a CGI profile file, [CGI], [Accept],
 [System], [Extra Headers], and [Form Literal], [Form External],
 and [Form huge]. They are described below:

 [CGI]                <== The standard CGI variables
 CGI Version=         The version of CGI spoken by the server
 Request Protocol=    The server's info protocol (e.g. HTTP/1.0)
 Request Method=      The method specified in the request (e.g., "GET")
 Request Keep-Alive=  If the client requested connection re-use (Yes/No)
 Executable Path=     Physical pathname of the back-end (this program)
 Logical Path=        Extra path info in logical space
 Physical Path=       Extra path info in local physical space
 Query String=        String following the "?" in the request URL
 Content Type=        MIME content type of info supplied with request
 Content Length=      Length, bytes, of info supplied with request
 Request Range=       Byte-range specfication received with request
 Server Software=     Version/revision of the info (HTTP) server
 Server Name=         Server's network hostname (or alias from config)
 Server Port=         Server's network port number
 Server Admin=        E-Mail address of server's admin. (config)
 Referer=             URL of referring document
 From=                E-Mail of client user (rarely seen)
 User Agent=          String describing client/browser software/version
 Remote Host=         Remote client's network hostname
 Remote Address=      Remote client's network address
 Authenticated Username=Username if present in request
 Authenticated Password=Password if present in request
 Authentication Method=Method used for authentication (e.g., "Basic")
 Authentication Realm=Name of realm for users/groups

 [Accept]             <== What the client says it can take
 The MIME types found in the request header as
    Accept: xxx/yyy; zzzz...
 are entered in this section as
    xxx/yyy=zzzz...
 If only the MIME type appears, the form is
    xxx/yyy=Yes

 [System]             <== Windows interface specifics
 GMT Offset=          Offset of local timezone from GMT, seconds (LONG!)
 Output File=         Pathname of file to receive results
 Content File=        Pathname of file containing raw request content
 Debug Mode=          If server's CGI debug flag is set (Yes/No)

 [Extra Headers]
 Any "extra" headers found in the request that activated this
 program. They are listed in "key=value" form. Usually, you'll see
 at least the name of the browser here as "User-agent".

 [Form Literal]
 If the request was a POST from a Mosaic form (with content type of
 "application/x-www-form-urlencoded"), the server will decode the
 form data. Raw form input is of the form "key=value&key=value&...",
 with the value parts "URL-encoded". The server splits the key=value
 pairs at the '&', then spilts the key and value at the '=',
 URL-decodes the value string and puts the result into key=value
 (decoded) form in the [Form Literal] section of the INI.

 [Form External]
 If the decoded value string is more than 254 characters long,
 or if the decoded value string contains any control characters
 or quote marks the server puts the decoded value into an external
 tempfile and lists the field in this section as:
    key=<pathname> <length>
 where <pathname> is the path and name of the tempfile containing
 the decoded value string, and <length> is the length in bytes
 of the decoded value string.

 [Form File]
 If the form data contained any uploaded files, they are described in
 this section as:
    key=[<pathname>] <length> <type> <encoding> [<name>]
 where <pathname> is the path and name of the tempfile containing the
 uploaded file, <length> is the length in bytes of the uploaded file,
 <type> is the content type of the uploaded file as sent by the browser,
 <encoding> is the content-transfer encoding of the uploaded file, and
 <name> is the original file name of the uploaded file.

 [Form Huge]
 If the raw value string is more than 65,536 bytes long, the server
 does no decoding. In this case, the server lists the field in this
 section as:
    key=<offset> <length>
 where <offset> is the offset from the beginning of the Content File
 at which the raw value string for this key is located, and <length>
 is the length in bytes of the raw value string. You can use the
 <offset> to perform a "Seek" to the start of the raw value string,
 and use the length to know when you have read the entire raw string
 into your decoder.

 Examples:

    [Form Literal]
    smallfield=123 Main St. #122

    [Form External]
    field300chars=c:\website\cgi-tmp\1a7fws.000 300
    fieldwithlinebreaks=c:\website\cgi-tmp\1a7fws.001 43

    [Form Huge]
    field230K=c:\website\cgi-tmp\1a7fws.002 276920
--------------------------------------------------------------------------------------*/
// ==================
// Global Constants
// ==================
#define MAX_CMDARGS 8							// Max # of command line args
#define ENUM_BUF_SIZE 4096						// Key enumeration buffer, see GetProfile()

      // These are the limits for the website server

#define MAX_XHDR 100							// Max # of "extra" request headers
#define MAX_ACCTYPE 100							// Max # of Accept: types in request
#define MAX_FORM_TUPLES 100						// Max # form key=value pairs
#define MAX_HUGE_TUPLES 16						// Max # "huge" form fields
#define MAX_FILE_TUPLES 16						// Max # of uploaded file tuples

// ====================
// Error Codes
// ====================
#define ERR_ARGCOUNT 32767
#define ERR_BAD_REQUEST 32766					// HTTP 400
#define ERR_UNAUTHORIZED 32765					// HTTP 401
#define ERR_PAYMENT_REQUIRED 32764				// HTTP 402
#define ERR_FORBIDDEN 32763						// HTTP 403
#define ERR_NOT_FOUND 32762						// HTTP 404
#define ERR_INTERNAL_ERROR 32761				// HTTP 500
#define ERR_NOT_IMPLEMENTED 32760				// HTTP 501
#define ERR_TOO_BUSY 32758						// HTTP 503 (experimental)
#define ERR_NO_FIELD 32757						// GetxxxField "no field".
#define CGI_ERR_START 32757						// Start of our errors.
#define CGI_CANT_OPEN_OUT_FILE 32756			// Can't open our outfile.
#define CGI_AUTH_FILE_ERROR 32755				// Problem opening the auth file.
#define CGI_REQ_FNUM_ERROR 32754				// Problem opening request file number file.
#define CGI_REQ_FILE_ERROR 32753				// Problem opening Request file itself.
#define CGI_FORM_EXTERNAL_ERROR 32749			// Problem with external form code.

class Tuple;									// Global prototypes
class FileTuple;
class HugeTuple;

class CWinCGI
{
public:

	// ====================
	// CGI  Variables
	// ====================
	CString CGI_ServerSoftware;
	CString CGI_ServerName;
	long CGI_ServerPort;
	CString CGI_RequestProtocol;
	CString CGI_ServerAdmin;
	CString CGI_Version;
	CString CGI_RequestMethod;
	long CGI_RequestKeepAlive;
	CString CGI_LogicalPath;
	CString CGI_PhysicalPath;
	CString CGI_ExecutablePath;
	CString CGI_QueryString;
	CString CGI_RequestRange;
	CString CGI_Referer;
	CString CGI_From;
	CString CGI_UserAgent;
	CString CGI_RemoteHost;
	CString CGI_RemoteAddr;
	CString CGI_AuthUser;
	CString CGI_AuthPass;
	CString CGI_AuthType;
	CString CGI_AuthRealm;
	CString CGI_ContentType;
	long CGI_ContentLength;

	// ----------------
	// System Variables
	// ----------------
	CTime CGI_GMTOffset;									// GMT offset (time serial)
	CString CGI_ContentFile;								// Content/Input file pathname
	CString CGI_OutputFile;									// Output file pathname from CGI-ProfileFile
	CStdioFile CGI_OutFile;									// Object to access CGI-ProfileFile.
	long CGI_DebugMode;										// Script Tracing flag from server
	CString CGI_ProfileFile;								// Profile file pathname

public:
	CWinCGI();
	~CWinCGI();
	BOOL FieldPresent(CString &key);
	CString GetSmallField(CString &key);
	void InitializeCGI(int argc, char *argv[]);
	void Send(CString &s);
	void SendNoOp();
	void errorhandler(int error_code);
	
private:
	void GetAcceptTypes();
	void GetExtraHeaders();
	void GetFormTuples();
	CString GetProfile(char *sSection, CString &sKey);
	void ParseFileValue(CString &buf, FileTuple tmp);
	CString FindExtraHeader(CString &key);

	Tuple *CGI_AcceptTypes;						// Pointers to arrays.
	Tuple *CGI_ExtraHeaders;
	Tuple *CGI_FormTuples;
	long CGI_NumAcceptTypes;					// # of live entries in array
	long CGI_NumExtraHeaders;					// # of live entries in array
	long CGI_NumFormTuples;						// # of live entries in array

	HugeTuple *CGI_HugeTuples;
	long CGI_NumFileTuples;						// # of live entries in array

	FileTuple *CGI_FileTuples;
	long CGI_NumHugeTuples;						// # of live entries in array
};

#endif
