unit CustView;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, DBCtrls, Grids, DBGrids, ComCtrls, StdCtrls, Mask, Buttons,
  Menus, afilter, filtcomp, adbgrid, aDatedit, aflookup;

type
  TfmCustView = class(TForm)
    MainMenu1: TMainMenu;
    About1: TMenuItem;
    DBNavigator1: TDBNavigator;
    rgDataSet: TRadioGroup;
    DBGrid1: TDBGrid;
    Panel1: TPanel;
    Label3: TLabel;
    MaskEditFilter1: TMaskEditFilter;
    Label1: TLabel;
    FilterLink1: TFilterLink;
    CheckBoxFilter1: TCheckBoxFilter;
    DateFilter1: TDateFilter;
    DateFilter2: TDateFilter;
    Label4: TLabel;
    FilterLink2: TFilterLink;
    FilterLink3: TFilterLink;
    FilterLink4: TFilterLink;
    AutoDBGrid1: TAutoDBGrid;
    FilterLink5: TFilterLink;
    ListBoxFilter1: TListBoxFilter;
    FilterLink6: TFilterLink;
    FilterLink7: TFilterLink;
    FilterLink8: TFilterLink;
    FilterLink9: TFilterLink;
    LookupComboFilter1: TLookupComboFilter;
    procedure DBGrid1Enter(Sender: TObject);
    procedure AutoDBGrid1Enter(Sender: TObject);
    procedure rgDataSetClick(Sender: TObject);
    procedure ListBoxFilter1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
  end;

var
  fmCustView: TfmCustView;

implementation

uses DM, About;

{$R *.DFM}

{ Set the navigator to the Customer Datasource. }
procedure TfmCustView.DBGrid1Enter(Sender: TObject);
begin
  DBNavigator1.DataSource := DBGrid1.DataSource;
end;

{ Set the navigator to the Orders Datasource. }
procedure TfmCustView.AutoDBGrid1Enter(Sender: TObject);
begin
  DBNavigator1.DataSource := AutoDBGrid1.DataSource;
end;

procedure TfmCustView.rgDataSetClick(Sender: TObject);
begin
  if(rgDataSet.ItemIndex = 0) then
    DM1.CustomerSource.DataSet := DM1.SQLCustomer
  else DM1.CustomerSource.DataSet := DM1.Customer;
end;

procedure TfmCustView.ListBoxFilter1Click(Sender: TObject);
begin
  if(ListBoxFilter1.ItemIndex <> 2) then begin
    FilterLink6.Macros := 'country';
    FilterLink8.Macros := 'country';
    FilterLink7.Macros := '';
    FilterLink9.Macros := '';
  end
  else begin
  if(LookupComboFilter1.AutoFilter.Value = '') then
    LookupComboFilter1.AutoFilter.Value := 'None';
    FilterLink7.Macros := 'country';
    FilterLink9.Macros := 'country';
    FilterLink6.Macros := '';
    FilterLink8.Macros := '';
  end;
end;

procedure TfmCustView.About1Click(Sender: TObject);
begin
  fmAboutBox.ShowModal;
end;

end.
