// handle.h

#ifndef HANDLE_H
#define HANDLE_H

class CHandle {       // Smart container for Window HANDLEs.
    HANDLE m_handle;  // HANDLE value.
public:
    CHandle(HANDLE handle = 0) : m_handle(handle) {}
    CHandle(const CHandle& handle)
        : m_handle(const_cast<CHandle&>(handle).reset()) {}
    ~CHandle()
    {
        if ( get() )
            CloseHandle(get());
    }
    CHandle& operator=(const HANDLE handle)
    {
        HANDLE temp = reset(handle);
        if ( temp )
            CloseHandle(temp);  // Close previous handle.
        return *this;
    }
    CHandle& operator=(const CHandle& handle)
    {
        if ( &handle == this )  // Avoid self assignment.
            return *this;
        return *this = const_cast<CHandle&>(handle).reset();
    }
    HANDLE get() const
    {
        return m_handle;
    }
    operator HANDLE() const     // Conversion operator.
    {
        return get();
    }
    HANDLE reset(const HANDLE handle = 0)
    {
        HANDLE temp = get();
        m_handle = handle;
        return temp;
    }
};

#endif
// End of File

