// sktest.c
#define STRICT
#include <windows.h>
#include "sendkeys.h"

#define ID_HOTKEY 1

LRESULT CALLBACK MainWndProc( HWND hwnd, UINT msg, WPARAM wParam,
            LPARAM lParam )
{
   switch(msg) {
      case WM_QUERYOPEN:
         return FALSE;

      case WM_CREATE:
         if( !RegisterHotKey(hwnd,ID_HOTKEY,
                                MOD_ALT|MOD_CONTROL,'H') ) {
            MessageBox(NULL,"Failed to Register Hotkey",
                "SKTEST",MB_SETFOREGROUND);
            return -1;
         }
         return 0;

      case WM_HOTKEY:
         if(wParam == ID_HOTKEY ) {
            if( !SendKeysStr("Hello World") )
               MessageBox(NULL,"SendKeys failed","SKTEST",
                    MB_SETFOREGROUND);
            return 0;
         }
         break;

      case WM_DESTROY:
         UnregisterHotKey(hwnd,ID_HOTKEY);
         PostQuitMessage(0);
         return 0;
   }
   return DefWindowProc(hwnd,msg,wParam,lParam);
}

int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
        LPSTR lpstrCmdLine, int nCmdShow )
{
   HWND hwndMain;
   static char szClassName[] = "SKTest";
   WNDCLASS wc;

   (void)hPrevInstance;
   (void)lpstrCmdLine;
   (void)nCmdShow;

   memset(&wc,0,sizeof(wc));
   wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
   wc.hCursor       = LoadCursor(NULL,IDC_ARROW);
   wc.hIcon         = LoadIcon(NULL,IDI_APPLICATION);
   wc.lpfnWndProc   = MainWndProc;
   wc.lpszClassName = szClassName;
   wc.hInstance     = hInstance;
   RegisterClass(&wc);
   hwndMain = CreateWindow(szClassName,"SKTEST - Press Ctrl+Alt+H",
               WS_OVERLAPPEDWINDOW,
               CW_USEDEFAULT,CW_USEDEFAULT,
               CW_USEDEFAULT,CW_USEDEFAULT,
               NULL,NULL,hInstance,NULL);
   if(hwndMain) {
      MSG msg;
      ShowWindow(hwndMain,SW_SHOWMINNOACTIVE);
      UpdateWindow(hwndMain);
      while( GetMessage(&msg,0,0,0) ) {
         DispatchMessage(&msg);
         TranslateMessage(&msg);
      }
   }
   return 0;
}
