unit Tipdemop;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Menus, StdCtrls, Tipofday, IniFiles;

const
   UM_TIPOFDAY = WM_USER + 42;
   {Custom message used to force Delphi to display the form first,
    then the Help Tips}

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Help1: TMenuItem;
    Contents1: TMenuItem;
    Search1: TMenuItem;
    N1: TMenuItem;
    miShowTips: TMenuItem;
    N2: TMenuItem;
    About1: TMenuItem;
    Label1: TLabel;
    TipOfTheDay1: TTipOfTheDay;
    Label2: TLabel;
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Help1Click(Sender: TObject);
    procedure miShowTipsClick(Sender: TObject);
    procedure Contents1Click(Sender: TObject);
  private
    { Private declarations }
    {This method is called whenever the UM_TIPOFDAY message is posted}
    procedure ShowTipOfTheDay(var TheMsg: TMessage); message UM_TIPOFDAY;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  ShowTips: Boolean; {Track the current status of users choice}

implementation

{$R *.DFM}

procedure TForm1.ShowTipOfTheDay(var TheMsg: TMessage);
begin
  {tick the Show On Startup checkbox, if relevant}
  if ShowTips = True then
    TipOfTheDay1.ShowTipsOnStartup := True
  else
    TipOfTheDay1.ShowTipsOnStartup := False;
  {display the tips}
  TipOfTheDay1.Execute;
  {if user changed Show tips on Startup then change form variable}
  if TipOfTheDay1.ShowTipsOnStartup = True then
    ShowTips := True
  else
    ShowTips := False;
end;

procedure TForm1.FormShow(Sender: TObject);
var
  userIni: TIniFile;
begin
  {Open the ini file, read it's values, then close it}
  userIni := TIniFile.Create(ExtractFilePath(Application.ExeName)+'\TIPDEMO.INI');
  if userIni.ReadBool('Help', 'ShowTipOfTheDay', True) = True then
    ShowTips := True
  else
    ShowTips := False;
  userIni.Free;
  {Does the user want us to display it or not?}
  if ShowTips = True then
    PostMessage(Handle, UM_TIPOFDAY, 0, 0);
    {posting the dummy message calls the ShowTipOfTheDay procedure}
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
var
  userIni: TIniFile;
begin
  {Open the ini file, write the users preferences, then close it}
  userIni := TIniFile.Create(ExtractFilePath(Application.ExeName)+'\TIPDEMO.INI');
  if ShowTips = True then
    userIni.WriteBool('Help', 'ShowTipOfTheDay', True)
  else
    userIni.WriteBool('Help', 'ShowTipOfTheDay', False);
  userIni.Free;
end;

procedure TForm1.Help1Click(Sender: TObject);
begin
  {Show a tick against the menu if the user
   has opted to display tips on startup}
  if ShowTips = True then
    miShowTips.Checked := True
  else
    miShowTips.Checked := False;
end;

procedure TForm1.miShowTipsClick(Sender: TObject);
begin
  PostMessage(Handle, UM_TIPOFDAY, 0, 0);
  {posting the dummy message calls the ShowTipOfTheDay procedure}
end;

procedure TForm1.Contents1Click(Sender: TObject);
begin
  Application.HelpFile := 'TIPOFDAY.HLP';
  Application.HelpCommand(HELP_CONTENTS, 0);
end;

end.
