unit complexu;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, DBGrids, DB, DBTables, StdCtrls, r_line, DBCtrls, Buttons,
  ExtCtrls;

type
  TForm1 = class(TForm)
    repbn: TButton;
    Items: TQuery;
    ItemsOrderNo: TFloatField;
    ItemsItemNo: TFloatField;
    ItemsQty: TIntegerField;
    ItemsDescription: TStringField;
    ItemsListPrice: TCurrencyField;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    rep: rline;
    ItemsSumma: TCurrencyField;
    LabelBn: TButton;
    labrep: rline;
    blf: TTable;
    blfSpeciesName: TStringField;
    blfLengthcm: TFloatField;
    blfNotes: TMemoField;
    memobn: TButton;
    memorep: rline;
    blfGraphic: TGraphicField;
    DataSource2: TDataSource;
    memorep2: rline;
    memo2bn: TButton;
    procedure repbnClick(Sender: TObject);
    procedure repPage(PageN: Integer);
    procedure ItemsCalcFields(DataSet: TDataSet);
    procedure LabelBnClick(Sender: TObject);
    procedure memobnClick(Sender: TObject);
    procedure memo2bnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.repbnClick(Sender: TObject);
var i: integer;
    ordnum,ordsum, grandsum: extended;
begin
  with rep do
  begin
    openreport;
    ordnum:=itemsorderno.value;
    ordsum:=0;
    grandsum:=0;
    band('header',[i]);
    for i:=0 to 60 do
    begin
      band('line',[itemsorderno.value,itemsdescription.value,itemsqty.value,
                   itemslistprice.value,itemssumma.value]);
      ordsum:=ordsum+itemssumma.value;
      grandsum:=grandsum+itemssumma.value;
      items.next;
      if ordnum<>itemsorderno.value then
      begin
        band('ordertotal', [ordsum]);
        ordsum:=0;
        ordnum:=itemsorderno.value;
      end;
    end;
    band('grandtotal',[grandsum]);
    out([date]);
    preview(Self);
  end;
end;

procedure TForm1.repPage(PageN: Integer);
begin
  with rep do
  begin
    out([date]);
    band('header',[date]);
    tplpage:=2;
  end;
end;

procedure TForm1.ItemsCalcFields(DataSet: TDataSet);
begin
itemssumma.value:=itemslistprice.value*itemsqty.value;
end;

procedure TForm1.LabelBnClick(Sender: TObject);
var i: integer;
    ordnum,ordsum: extended;
begin
  with labrep do
  begin
    openreport;
    ordnum:=itemsorderno.value;
    ordsum:=0;
    for i:=0 to 60 do
    begin
      band('line',[itemsdescription.value, itemssumma.value]);
      ordsum:=ordsum+itemssumma.value;
      items.next;
      if ordnum<>itemsorderno.value then
      begin
        band('total', [ordsum]);
        ordsum:=0;
        ordnum:=itemsorderno.value;
        tab;
      end;
    end;
    preview(Self);
  end;
end;


procedure TForm1.memobnClick(Sender: TObject);
var mem: string;
    p1,p2,pg: integer;
    pic: tpicture;
begin
  with memorep do
  begin
    openreport;
    pic:=getpictbyfname('Yacht.wmf');
    blf.first;
    while not blf.eof do
    begin
      mem:=blfnotes.value;
      p1:=getppos;    {remember where 1st column's band printed}
      pg:=page;       {and page}
      pic.assign(blfgraphic);
      band('line',[blfspeciesname.value, blflengthcm.value]);
      p2:=setppos(p1); {2nd column's band begin from remembered position}
      while length(mem)<>0 do band('memo',[fitinfield('thememo',mem)]);
//  if sum height of second column's bands less than height of first column's band,
//  ensure minimal height
      if (getppos<p2) and (page=pg) then setppos(p2);
      blf.next;
    end;
    preview(Self);
  end;
end;

procedure TForm1.memo2bnClick(Sender: TObject);
var i: integer;
    color: tcolor;
begin
  with memorep2 do
  begin
    openreport;
    blf.first;
    color:=clgreen;
    while not blf.eof do
    begin
      setbandattr('line',color,false,false);
      band('line',[blfnotes.value,blfspeciesname.value]);
      blf.next;
      inc(color,10000);
    end;
    preview(Self);
  end;
end;

end.
