unit DemoUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DBTables, DB, qiField, qiQuery, qiSelect, qiWdw, TablePrn, MemoDlg,
  qiFrBldr, qiLookup, qiOrder, qiGroup, qiFilter, qiFormat, qiArchiv,
  StdCtrls;

type
  TDemoForm = class(TForm)
    Customers: TTable;
    Employees: TTable;
    Vendors: TTable;
    Orders: TTable;
    Items: TTable;
    Parts: TTable;
    CustomersCustNo: TFloatField;
    CustomersCompany: TStringField;
    CustomersAddr1: TStringField;
    CustomersCity: TStringField;
    CustomersTaxRate: TFloatField;
    EmployeesEmpNo: TIntegerField;
    EmployeesLastName: TStringField;
    VendorsVendorNo: TFloatField;
    VendorsVendorName: TStringField;
    VendorsCity: TStringField;
    VendorsPreferred: TBooleanField;
    OrdersCustNo: TFloatField;
    OrdersSaleDate: TDateTimeField;
    OrdersEmpNo: TIntegerField;
    OrdersPaymentMethod: TStringField;
    OrdersTaxRate: TFloatField;
    OrdersAmountPaid: TCurrencyField;
    ItemsOrderNo: TFloatField;
    ItemsItemNo: TFloatField;
    ItemsPartNo: TFloatField;
    ItemsQty: TIntegerField;
    ItemsDiscount: TFloatField;
    PartsPartNo: TFloatField;
    PartsVendorNo: TFloatField;
    PartsDescription: TStringField;
    PartsListPrice: TCurrencyField;
    FieldInfo: TFieldInfo;
    QueryInfo: TQueryInfo;
    QueryWdw: TQIQueryWindow;
    SelectDlg: TQISelectDialog;
    OrdersOrderNo: TFloatField;
    Label1: TLabel;
    Label2: TLabel;
    QueryBtn: TButton;
    FilterBtn: TButton;
    Archiver: TQIArchiver;
    Formatter: TQIFormatter;
    FilterDlg: TQIFilterDialog;
    GroupDlg: TQIGroupDialog;
    OrderDlg: TQIOrderDialog;
    LookupDlg: TQILookupDialog;
    FilterBldr: TQIFilterBuilder;
    EditDlg: TMemoDialog;
    TablePrinter: TTablePrinter;
    CloseBtn: TButton;
    Label3: TLabel;
    procedure QueryInfoChange(Sender: TObject);
    procedure QueryBtnClick(Sender: TObject);
    procedure QueryWdwEdit(Sender: TObject);
    procedure QueryWdwFilter(Sender: TObject);
    procedure QueryWdwSelect(Sender: TObject);
    procedure QueryWdwOrder(Sender: TObject);
    procedure QueryWdwLoad(Sender: TObject);
    procedure QueryWdwSave(Sender: TObject);
    procedure QueryWdwPrint(Sender: TObject);
    procedure QueryWdwLookup(Sender: TObject);
    procedure QueryWdwFindNext(Sender: TObject);
    procedure SelectDlgGrouping(Sender: TObject);
    procedure FilterBtnClick(Sender: TObject);
    procedure CloseBtnClick(Sender: TObject);
  private
    procedure ForceBridgingJoins;
  public
  end;

var
  DemoForm: TDemoForm;

implementation

{$R *.DFM}

procedure TDemoForm.QueryInfoChange(Sender: TObject);
begin
  ForceBridgingJoins;
  Formatter.BuildSQLQuery(QueryWdw.SQLScript);
  Formatter.BuildUserQuery(QueryWdw.DisplayScript);
  QueryWdw.Show;
end;

procedure TDemoForm.QueryBtnClick(Sender: TObject);
begin
  QueryInfoChange(nil);
  QueryWdw.Show;
end;

procedure TDemoForm.QueryWdwEdit(Sender: TObject);
begin
  EditDlg.Execute(QueryWdw.SQLScript);
end;

procedure TDemoForm.QueryWdwFilter(Sender: TObject);
begin
  FilterDlg.Execute;
end;

procedure TDemoForm.QueryWdwSelect(Sender: TObject);
begin
  SelectDlg.Execute;
end;

procedure TDemoForm.QueryWdwOrder(Sender: TObject);
begin
  OrderDlg.Execute;
end;

procedure TDemoForm.QueryWdwLoad(Sender: TObject);
begin
  Archiver.Load;
end;

procedure TDemoForm.QueryWdwSave(Sender: TObject);
begin
  Archiver.Store('', QueryWdw.DisplayScript);
end;

procedure TDemoForm.QueryWdwPrint(Sender: TObject);
var
  i: Integer;
  s: string;
begin
  with TablePrinter, QueryWdw do begin
    DataSource := QuerySource;
    s := '';
    for i := 0 to DisplayScript.Count-1 do
      s := s + DisplayScript[i] + '.  ';
    SubHeader := s;
    Execute;
  end;
end;

procedure TDemoForm.QueryWdwLookup(Sender: TObject);
begin
  if not QueryWdw.QuerySource.DataSet.Active then Exit;
  if LookupDlg.Execute then
    with QueryInfo.Lookup do
      LookupDlg.FindFirstValue(TQuery(QueryWdw.QuerySource.DataSet),
        Field.SQLName, Value);
end;

procedure TDemoForm.QueryWdwFindNext(Sender: TObject);
begin
  if not QueryWdw.QuerySource.DataSet.Active then Exit;
  with QueryInfo.Lookup do
    LookupDlg.FindNextValue(TQuery(QueryWdw.QuerySource.DataSet),
      Field.SQLName, Value);
end;

procedure TDemoForm.SelectDlgGrouping(Sender: TObject);
begin
  GroupDlg.Execute;
end;

{
  join links:      Vendors - Parts - Items - Orders - Customers
                                                \ - Employees
}
procedure TDemoForm.ForceBridgingJoins;
var
  item, part, vendor, order, cust, empl: TTableItem;
begin
  with QueryInfo do begin   {ensure bridging joins made where required -}
    item   := Tables.ByTableRef(Items);
    part   := Tables.ByTableRef(Parts);       {TQueryInfo gives read-only acc. }
    vendor := Tables.ByTableRef(Vendors);     {to the Tables, Fields & Joins   }
    order  := Tables.ByTableRef(Orders);      {lists of its connected FieldInfo}
    cust   := Tables.ByTableRef(Customers);
    empl   := Tables.ByTableRef(Employees);
    part.Master :=                                   {a table item with its    }
      (TableUsed(vendor) and TableUsed(item))  or    {master property set will }
      (TableUsed(vendor) and TableUsed(order)) or    {always be included in    }
      (TableUsed(vendor) and TableUsed(cust))  or    {the FROM clause and its  }
      (TableUsed(vendor) and TableUsed(empl));       {common joins defined by  }
    item.Master :=                                   {QIFormatter in the script}
      (TableUsed(part)   and TableUsed(order)) or
      (TableUsed(part)   and TableUsed(cust))  or
      (TableUsed(part)   and TableUsed(empl))  or
      (TableUsed(vendor) and TableUsed(order)) or
      (TableUsed(vendor) and TableUsed(cust))  or
      (TableUsed(vendor) and TableUsed(empl));
    order.Master :=
      (TableUsed(cust) and TableUsed(item))   or
      (TableUsed(cust) and TableUsed(part))   or
      (TableUsed(cust) and TableUsed(vendor)) or
      (TableUsed(cust) and TableUsed(empl))   or
      (TableUsed(empl) and TableUsed(item))   or
      (TableUsed(empl) and TableUsed(part))   or
      (TableUsed(empl) and TableUsed(vendor));             {phew!}
  end;
end;

procedure TDemoForm.FilterBtnClick(Sender: TObject);
begin
  FilterBldr.Execute;
end;

procedure TDemoForm.CloseBtnClick(Sender: TObject);
begin
  Close;
end;

end.
