unit MemoDlg;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons;

type
  TMemoDialog = class(TComponent)
  private
    FCaption: string;
    FBorBtns: Boolean;
    FModalResult: TModalResult;
    FReadOnly: Boolean;
  protected
  public
    constructor Create(AOwner: TComponent); override;
    function Execute(Lines: TStrings): Boolean;
    property ModalResult: TModalResult read FModalResult write FModalResult;
  published
    property Caption: string read FCaption write FCaption;
    property BorBtns: Boolean read FBorBtns write FBorBtns default False;
    property ReadOnly: Boolean read FReadOnly write FReadOnly;
  end;

  TMemoForm = class(TForm)
    Memo: TMemo;
    CancelBtn: TBitBtn;
    OKBtn: TBitBtn;
    WordWrapCheck: TCheckBox;
    procedure MemoChange(Sender: TObject);
    procedure WordWrapCheckClick(Sender: TObject);
  private
  public
  end;

implementation

{$R *.DFM}

constructor TMemoDialog.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FCaption := 'Memo';
end;

function TMemoDialog.Execute(Lines: TStrings): Boolean;
begin
  Result := False;
  with TMemoForm.Create(Self) do
  try
    Caption := FCaption;
    Memo.Lines.Assign(Lines);
    Memo.ReadOnly := FReadOnly;
    if FBorBtns then begin
      OKBtn.Kind := bkOK;

      CancelBtn.Kind := bkCancel;

    end;

    FModalResult := ShowModal;

  finally

    Result := FModalResult = mrOK;

    if Result then Lines.Assign(Memo.Lines);

    Free;

  end;
end;

procedure TMemoForm.MemoChange(Sender: TObject);
begin
  OKBtn.Enabled := True;
end;

procedure TMemoForm.WordWrapCheckClick(Sender: TObject);
begin
  Memo.WordWrap := WordWrapCheck.Checked;
  if WordWrapCheck.Checked then
    Memo.ScrollBars := ssVertical else
    Memo.ScrollBars := ssBoth;
end;

end.
