(*
================================================================================
DesignerForms Trial Version Demo
================================================================================
  Credits:
  This demo makes use of the source code for the freeware "URL Label" component
  by Ahto Tanner.  While the component is not being used directly, it's source
  is being used to create the URL for our home page that appears on the last
  screen of this demo.  Thanks Ahto for the good work.

  For more information on the "URL Label" component:
      URL Label
      Freeware - created by Ahto Tanner (www.estpak.ee/~ahto)
      Special thanks to Chad Z. Hower from Phoenix Business Enterprises

  Notes:
  For those who are interested, navigation in this demo occurs between pages
  and between steps in a page.  Step navigation generally speaking relates
  to the hiding and showing of bullets, and page navigation relates to
  displaying a high level feature of DesignerForms.
================================================================================
*)
unit Main;

interface

uses
  WinTypes, WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Buttons, Menus, ShellApi, ClipBrd, PGSubCls, PGDsgFrm, PGGlyph;

type
  TMainForm = class(TForm)
    Panel1: TPanel;
    Panel: TPanel;
    Panel3: TPanel;
    Pages: TNotebook;
    CaptionBar: TPGCaptionBar;
    PGCaptionBarGlyph1: TPGCaptionBarGlyph;
    CurrentPage: TPanel;
    ExampleButton1: TPGCaptionBarButton;
    InformationMenu: TPopupMenu;
    HowtoRegister1: TMenuItem;
    Label1: TLabel;
    Page1Label1a: TLabel;
    StartButton: TPGCaptionBarGlyph;
    StartButtonTimer: TTimer;
    Panel2: TPanel;
    StatusBar: TPanel;
    Panel4: TPanel;
    NextButton: TButton;
    BackButton: TButton;
    Page2Label3: TLabel;
    Page2Label2: TLabel;
    Page2Label: TLabel;
    Page2Label4: TLabel;
    Page1Label5: TLabel;
    Page2Label1: TLabel;
    Button1: TButton;
    Image1: TImage;
    Image2: TImage;
    Page1Bullet: TImage;
    Page2Bullet: TImage;
    Label2: TLabel;
    Page3Label5: TLabel;
    Page3Label4: TLabel;
    Page3Label2: TLabel;
    Page3Label1: TLabel;
    Page3Bullet: TImage;
    Label9: TLabel;
    Image10: TImage;
    Label3: TLabel;
    Page3Label3: TLabel;
    Page4Label4: TLabel;
    Page4Label3: TLabel;
    Page4Label2: TLabel;
    Page4Label1: TLabel;
    Page4Bullet: TImage;
    Label10: TLabel;
    Label11: TLabel;
    Image4: TImage;
    Page5Label3: TLabel;
    Page5Label2: TLabel;
    Page5Label1: TLabel;
    Label8: TLabel;
    Label12: TLabel;
    Page5Bullet: TImage;
    Label4: TLabel;
    Label5: TLabel;
    Image3: TImage;
    Page6Label1: TLabel;
    Page6Bullet: TImage;
    Page6Label2: TLabel;
    Page6Label3: TLabel;
    Page6Label4: TLabel;
    Label7: TLabel;
    Image7: TImage;
    Page7Bullet: TImage;
    Label13: TLabel;
    Page7Label1: TLabel;
    Page7Label2: TLabel;
    Page7Label3: TLabel;
    Page8Label3: TLabel;
    Page8Label2: TLabel;
    Page8Label1: TLabel;
    Page8Bullet: TImage;
    Label19: TLabel;
    Image9: TImage;
    Label20: TLabel;
    Page8Label2a: TLabel;
    Page8Label3a: TLabel;
    Page8Label3b: TLabel;
    Page8Label3c: TLabel;
    Page8Label3d: TLabel;
    Page8Label1a: TLabel;
    Page7Label4: TLabel;
    Label14: TLabel;
    Page1Label2a: TLabel;
    Page1Label3a: TLabel;
    Page1Label4a: TLabel;
    Page1Image1: TImage;
    Page1Image2: TImage;
    Page1Image3: TImage;
    Page1Image4: TImage;
    Page1Label1: TLabel;
    Page1Label2: TLabel;
    Page1Label3: TLabel;
    Page1Label4: TLabel;
    Image8: TImage;
    Image5: TImage;
    Image11: TImage;
    Label15: TLabel;
    Page7Label5a: TLabel;
    Page7Label5b: TLabel;
    Page7Label5c: TLabel;
    PGCaptionBarButton1: TPGCaptionBarButton;
    AboutTheProgrammersGuild1: TMenuItem;
    URLPopupMenu: TPopupMenu;
    URLCopyMenuItem: TMenuItem;
    Page7Label1b: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure NextButtonClick(Sender: TObject);
    procedure BackButtonClick(Sender: TObject);
    procedure CurrentPageMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure ExampleButton1MouseMove(Sender: TObject; Shift: TShiftState;
      X, Y: Integer);
    procedure StartButtonTimerTimer(Sender: TObject);
    procedure PGCaptionBarButton1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure AbouttheProgrammersGuild1Click(Sender: TObject);
    procedure HowtoRegister1Click(Sender: TObject);
    procedure URLLabelClick(Sender: TObject);
    procedure StatusBarClick(Sender: TObject);
    procedure URLCopyMenuItemClick(Sender: TObject);
    procedure Page7Label5bMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Page8Label2aMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Page7Label1bMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
  private
    GoingForward: Boolean;
    PlayingForward: Boolean;
    CurrStep: Integer;
  public
    { Used to control step navigation. }
    function PrevStep: Integer;
    function NextStep: Integer;
    function FirstStep: Integer;
    function LastStep: Integer;
    procedure DisplayStep(AStep: Integer);
    function NumberOfStepsInPage(APageIndex: Integer): Integer;
    procedure InitNewStep;
    { Used to control page navigation. }
    function GoBackward: Boolean;
    function GoForward: Boolean;
    function FirstPage: Integer;
    function LastPage: Integer;
    function CurrPage: Integer;
    procedure DisplayPage(APageIndex: Integer);
    procedure DisplayNextPage;
    procedure DisplayPrevPage;
    procedure InitEndOfPage(APageIndex: Integer);
    { Routines used to hide and show objects depending on the direction }
    { that we're heading. (ie Depends on whether the user has clicked the }
    { forward or backward button.) }
    procedure ShowObject(AnObjectName: string);
    function PageObjectName(AName: string): string;
    procedure ShowBullet(AStep: Integer);
    procedure ShowBulletAndGlyph(AStep: Integer);
    function GetPageObject(AnObjectName: string; var AControl: TControl): Boolean;
    { Management of displaying examples. }
    procedure DoExample(ACaption: string; AnEvent: TNotifyEvent);
    procedure HideExample(AButton: TPGCaptionBarButton);
    procedure ShowExample(AButton: TPGCaptionBarButton; ACaption: string; AnEvent: TNotifyEvent);
    procedure StartExampleAnimation;
    procedure StopExampleAnimation;
    { Events assigned to the example buttons that appear in the caption bar. }
    procedure Page2Example1(Sender: TObject);
    procedure Page3Example1(Sender: TObject);
    procedure Page4Example1(Sender: TObject);
    procedure Page5Example1(Sender: TObject);
    { Other routines. }
    procedure ShowMsg(AMsg: string);
    procedure ShowForm(AForm: TForm; ShowModal: Boolean);
    procedure ShowAbout;
    procedure ChangeDirectory(APath: string);
    procedure DisplayHintInStatusBar(Sender: TObject);
    procedure UpdateStatusBar(StatusText: string);
    procedure UpdateNavigationState;
    procedure MakeHotSpotLabel(ALabel: TLabel);
  end;

var
  MainForm: TMainForm;

const
  crPGURLHand = 5;

function PGFullFilename(AFilename: string): string;

implementation

uses Page2_1, Page3_1, Page4_1, Page5_1;

{$R *.DFM}

{$IFDEF VER80}
  {$R URLLBL16.RES}
{$ELSE}
  {$R URLLBL32.RES}
{$ENDIF}

{ Shows or hides an object, depending on which way the demo is 'playing' }
procedure TMainForm.ShowObject(AnObjectName: string);
var
  AControl: TControl;
begin
  AControl := nil;

  AControl := TControl(FindComponent(AnObjectName));
  if (AControl <> nil) then
    AControl.Visible := PlayingForward;
end;

{ Given an object's name, look's for the object on the main form.  If it is }
{ found, the function returns true, and the AControl variable is updated to }
{ point to the control we were looking for. }
function TMainForm.GetPageObject(AnObjectName: string; var AControl: TControl): Boolean;
begin
  AControl := TControl(FindComponent(PageObjectName(AnObjectName)));
  Result := (AControl <> nil);
end;

function TMainForm.PageObjectName(AName: string): string;
begin
  Result := Format('Page%d%s', [CurrPage, AName]);
end;

{ Shows or hides a bullet and another object, depending on the }
{ direction we're 'playing'. }
procedure TMainForm.ShowBullet(AStep: Integer);
var
  ObjectToShow: TControl;
  ObjectToBullet: TControl;
  ObjectName: string;
  Bullet: TControl;
  BulletLeft: Integer;
  BulletTop: Integer;
begin
  { Find the bullet and the object.  They should exist. }
  ObjectName := 'Label' + IntToStr(AStep);
  PGAssert(GetPageObject(ObjectName, ObjectToShow), 'The object ' + ObjectName + ' doesnt exist.');
  PGAssert(GetPageObject('Bullet', Bullet), 'The bullet for this page doesnt exist.');

  { Figure out where to display the bullet. }
  ObjectToBullet := ObjectToShow;
  BulletLeft := ObjectToBullet.Left - Bullet.Width - 3;
  BulletTop  := ObjectToBullet.Top + 4;
  Bullet.Left := BulletLeft;
  Bullet.Top  := BulletTop;

  { Show the bullet and the object. }
  Bullet.Visible := PlayingForward;
  ObjectToShow.Visible := PlayingForward;
end;

procedure TMainForm.ShowBulletAndGlyph(AStep: Integer);
begin
  ShowBullet(AStep);
  ShowObject(PageObjectName('Image' + IntToStr(AStep)));
  ShowObject(PageObjectName('Label' + IntToStr(AStep) + 'A'));
end;

{ Used to force examples to hide between pages, and to ensure that bullets }
{ are always initially hidden. }
procedure TMainForm.InitNewStep;
var
  ABullet: TControl;
begin
  if not GoingForward then
    exit;

  HideExample(ExampleButton1);
  if GetPageObject('Bullet', ABullet) then
    ABullet.Visible := false;
end;

{ Enable, Disable, and Modify the navigation buttons depending on where we }
{ are in the demo's content. }
procedure TMainForm.UpdateNavigationState;
begin
  { At the first page ... }
  if (CurrPage = FirstPage) and (CurrStep = FirstStep) then
    begin
    BackButton.Enabled := false;
    NextButton.Enabled := true;
    exit;
    end;

  { At the last page ... }
  if (CurrPage = LastPage) and (CurrStep = NumberOfStepsInPage(CurrPage)) then
    begin
    BackButton.Enabled := true;
    NextButton.Enabled := false;
    exit;
    end;

  { At some page inbetween ... }
  BackButton.Enabled := true;
  NextButton.Enabled := true;
end;

procedure TMainForm.DisplayPage(APageIndex: Integer);
begin
  { Display the new page. }
  Pages.PageIndex := APageIndex - 1;

  { Show the new pages title in the current page title bar. }
  CurrentPage.Caption := Pages.ActivePage;
end;

procedure TMainForm.DisplayNextPage;
begin
  if CurrPage = LastPage then
    exit;
    
  { Display the new page. }
  Pages.PageIndex := Pages.PageIndex + 1;

  { Show the new pages title in the current page title bar. }
  CurrentPage.Caption := Pages.ActivePage;

  CurrStep := 0;
  GoForward;
end;

procedure TMainForm.DisplayPrevPage;
begin
  if CurrPage = FirstPage then
    exit;
    
  Pages.PageIndex := Pages.PageIndex - 1;
  InitEndOfPage(CurrPage);

  { Show the new pages title in the current page title bar. }
  CurrentPage.Caption := Pages.ActivePage;
end;

function TMainForm.FirstPage: Integer;
begin
  Result := 1;
end;

function TMainForm.LastPage: Integer;
begin
  Result := Pages.Pages.Count;
end;

function TMainForm.CurrPage: Integer;
begin
  Result := Pages.PageIndex + 1;
end;

function TMainForm.GoForward: Boolean;
var
  LastStep: Integer;
begin
  { Go to the next step. }
  GoingForward := true;
  PlayingForward := true;
  
  LastStep := CurrStep;
  CurrStep := NextStep;

  { If we're at a different step, then display it. }
  Result := (CurrStep <> LastStep);
  if Result then
    DisplayStep(CurrStep);
  UpdateNavigationState;
end;

function TMainForm.FirstStep: Integer;
begin
  Result := 1;
end;

function TMainForm.LastStep: Integer;
begin
  Result := 20;
end;

function TMainForm.GoBackward: Boolean;
var
  LastStep: Integer;
begin
  { Go to the prev step. }
  GoingForward := false;
  PlayingForward := false;
  DisplayStep(CurrStep);

  if (CurrStep = FirstStep) then
    begin
    DisplayPrevPage;
    exit;
    end;

  { If we're at a different step, then display it. }
  Result := (CurrStep <> LastStep);
  LastStep := CurrStep;
  CurrStep := PrevStep;

  PlayingForward := true;
  if Result then
    DisplayStep(CurrStep);
  UpdateNavigationState;
end;

function TMainForm.NextStep: Integer;
begin
  Result := PGMin(CurrStep + 1, LastStep);
end;

function TMainForm.PrevStep: Integer;
begin
  Result := PGMax(CurrStep - 1, FirstStep);
end;

procedure TMainForm.DisplayHintInStatusBar(Sender: TObject);
begin
  UpdateStatusBar(Application.Hint);
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  { Change to the project directory so the help file will be available. }
  ChangeDirectory(ExtractFilePath(Application.Exename));

  { Show the components help if the user needs help. }
  Application.HelpFile := PGFullFilename('PGDSGFRM.HLP');

  { Initialize showing hints in the status bar. }
  Application.OnHint := DisplayHintInStatusBar;
  UpdateStatusBar(EmptyStr);

  { Load hand cursors into hot spot labels. }
  MakeHotSpotLabel(Page7Label5b);
  MakeHotSpotLabel(Page7Label1b);
  MakeHotSpotLabel(Page8Label2a);

  { Show the Introduction page of the demo. }
  Pages.ActivePage := 'Introduction';
  CurrStep := 0;
  GoForward;
end;

procedure TMainForm.NextButtonClick(Sender: TObject);
begin
  GoForward;
end;

procedure TMainForm.BackButtonClick(Sender: TObject);
begin
  GoBackward;
end;

{ In Delphi 1.0, If you try and "ChDir" to a directory that was }
{ extracted from a filename with "ExtractFilePath", you will get an error }
{ because "ChDir" doesn't like trailing slashes, and "ExtractFilePath" }
{ leaves trailing slashes on.  This removes the trailing slash.  This }
{ problem only occurs under Windows 95. }
procedure TMainForm.ChangeDirectory(APath: string);
var
  LastCharPos: Integer;
begin
  { Remove the trailing slash if it exists. }
  LastCharPos := Length(APath);
  if APath[LastCharPos] = '\' then
    Delete(APath, LastCharPos, 1);

  { Change to the destination directory. }
  ChDir(APath);
end;

procedure TMainForm.UpdateStatusBar(StatusText: string);
begin
  if StatusBar.Caption = StatusText then
    exit;
  StatusBar.Caption := '  ' + StatusText;
end;

procedure TMainForm.CurrentPageMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  UpdateStatusBar(EmptyStr)
end;

procedure TMainForm.ExampleButton1MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  UpdateStatusBar('Click here for an Example.');
end;


procedure TMainForm.HideExample(AButton: TPGCaptionBarButton);
begin
  AButton.OnClick := nil;
  AButton.Visible := false;
  StopExampleAnimation;
end;

procedure TMainForm.DoExample(ACaption: string; AnEvent: TNotifyEvent);
begin
  if PlayingForward then
    ShowExample(ExampleButton1, ACaption, AnEvent)
  else
    HideExample(ExampleButton1);
end;

procedure TMainForm.ShowExample(AButton: TPGCaptionBarButton; ACaption: string; AnEvent: TNotifyEvent);
begin
  AButton.OnClick := AnEvent;
  AButton.Caption := ACaption;
  AButton.Visible := true;
  StartExampleAnimation;
end;

procedure TMainForm.Page2Example1(Sender: TObject);
begin
  StopExampleAnimation;
  ShowForm(FormPage2_1, true);
end;

procedure TMainForm.Page3Example1(Sender: TObject);
begin
  StopExampleAnimation;
  ShowForm(FormPage3_1, true);
end;

procedure TMainForm.Page4Example1(Sender: TObject);
begin
  StopExampleAnimation;
  ShowForm(FormPage4_1, true);
end;

procedure TMainForm.Page5Example1(Sender: TObject);
begin
  StopExampleAnimation;
  ShowForm(FormPage5_1, false);
end;

procedure TMainForm.ShowForm(AForm: TForm; ShowModal: Boolean);
begin
  { Always make sure we're in the correct demo directory. }
  ChangeDirectory(ExtractFilePath(Application.Exename));
  if ShowModal then
    AForm.ShowModal
  else
    AForm.Show;
end;

procedure TMainForm.StartExampleAnimation;
begin
  StartButtonTimer.Tag := 1;
  StartButton.Visible := true;
  StartButtonTimer.Enabled := true;
end;

procedure TMainForm.StopExampleAnimation;
begin
  StartButtonTimer.Tag := 1;
  StartButton.Visible := false;
  StartButtonTimer.Enabled := false; 
end;

{ Returns a fully qualified filename for files in the demo directory. }
function PGFullFilename(AFilename: string): string;
begin
  Result := ExtractFilePath(Application.Exename) + AFilename;
end;

procedure TMainForm.StartButtonTimerTimer(Sender: TObject);
begin
  case StartButtonTimer.Tag of
    1..12: StartButton.Visible := not StartButton.Visible;
  else
    begin
    StartButton.Visible := true;
    StartButtonTimer.Enabled := false;
    StartButtonTimer.Tag := 0;
    end;
  end;
  StartButtonTimer.Tag := StartButtonTimer.Tag + 1;
end;

procedure TMainForm.PGCaptionBarButton1Click(Sender: TObject);
begin
  StopExampleAnimation;
end;

procedure TMainForm.Button1Click(Sender: TObject);
begin
  Application.Terminate;
end;

function TMainForm.NumberOfStepsInPage(APageIndex: Integer): Integer;
begin
  case APageIndex of
    1: Result := 5;
    2: Result := 4;
    3: Result := 5;
    4: Result := 4;
    5: Result := 3;
    6: Result := 4;
    7: Result := 5;
    8: Result := 3;
  else
    Result := FirstStep;
  end;
end;

procedure TMainForm.DisplayStep(AStep: Integer);
begin
  InitNewStep;
  case CurrPage of
    1: { Page 1 }
       case AStep of
        1: ShowBulletAndGlyph(1);
        2: ShowBulletAndGlyph(2);
        3: ShowBulletAndGlyph(3);
        4: ShowBulletAndGlyph(4);
        5: ShowObject('Page1Label5');
        6: DisplayNextPage;
       end;

    2: { Page 2 }
       case AStep of
        1: ShowBullet(1);
        2: ShowBullet(2);
        3: ShowBullet(3);
        4: begin
           ShowObject('Page2Label4');
           DoExample('Example', Page2Example1);
           end;
        5: DisplayNextPage;
       end;

    3: { Page 3 }
       case AStep of
        1: ShowBullet(1);
        2: ShowBullet(2);
        3: ShowBullet(3);
        4: ShowBullet(4);
        5: begin
           ShowObject('Page3Label5');
           DoExample('Example', Page3Example1);
           end;
        6: DisplayNextPage;
       end;

    4: { Page 4 }
       case AStep of
        1: ShowBullet(1);
        2: ShowBullet(2);
        3: ShowBullet(3);
        4: begin
           ShowObject('Page4Label4');
           DoExample('Example', Page4Example1);
           end;
        5: DisplayNextPage;
       end;

    5: { Page 5 }
       case AStep of
        1: ShowBullet(1);
        2: ShowBullet(2);
        3: begin
           ShowObject('Page5Label3');
           DoExample('Example', Page5Example1);
           end;
        4: DisplayNextPage;
       end;

    6: { Page 6 }
       case AStep of
        1: ShowBullet(1);
        2: ShowBullet(2);
        3: ShowBullet(3);
        4: ShowObject('Page6Label4');
        5: DisplayNextPage;
       end;
       
    7: { Page 7 }
       case AStep of
        1: begin
           ShowBullet(1);
           ShowObject('Page7Label1b');
           end;
        2: ShowBullet(2);
        3: ShowBullet(3);
        4: ShowObject('Page7Label4');
        5: begin
           ShowObject('Page7Label5a');
           ShowObject('Page7Label5b');
           ShowObject('Page7Label5c');
           end;
        6: DisplayNextPage;
       end;

    8: { Page 8 }
       case AStep of
        1: begin
           ShowBullet(1);
           ShowObject('Page8Label1a');
           end;
        2: begin
           ShowBullet(2);
           ShowObject('Page8Label2a');
           end;
        3: begin
           ShowBullet(3);
           ShowObject('Page8Label3A');
           ShowObject('Page8Label3B');
           ShowObject('Page8Label3C');
           ShowObject('Page8Label3D');
           end;
        4: DisplayNextPage;
       end;
    end;
end;

procedure TMainForm.InitEndOfPage(APageIndex: Integer);
begin
  CurrStep := NumberOfStepsInPage(APageIndex);
  case APageIndex of
    2: ShowExample(ExampleButton1, 'Example', Page2Example1);
    3: ShowExample(ExampleButton1, 'Example', Page3Example1);
    4: ShowExample(ExampleButton1, 'Example', Page4Example1);
    5: ShowExample(ExampleButton1, 'Example', Page5Example1);
  end;
end;

procedure TMainForm.ShowMsg(AMsg: string);
begin
  MessageDlg(AMsg, mtInformation, [mbOk], 0);
end;

procedure TMainForm.ShowAbout;
var
  AMsg: string;
begin
  AMsg := 'DesignerForms 1.0 For Delphi' + #13#13 + 'by The Programmers' + #39 + ' Guild';
  MainForm.ShowMsg(AMsg);
end;

procedure TMainForm.AbouttheProgrammersGuild1Click(Sender: TObject);
begin
  ShowAbout;
end;

procedure TMainForm.HowtoRegister1Click(Sender: TObject);
begin
  Application.HelpContext(11);
end;

{ URL Label - See Credits at beginning of unit. }
procedure TMainForm.URLLabelClick(Sender: TObject);
var
  AnUrl: array[0..255] of char;
begin
  StrPCopy(AnUrl, 'http://ourworld.compuserve.com/homepages/TheProgrammersGuild/Index.htm');
  ShellExecute(Application.Handle, 'open', AnUrl, nil, nil, SW_NORMAL);
end;

{ URL Label - See Credits at beginning of unit. }
procedure TMainForm.URLCopyMenuItemClick(Sender: TObject);
begin
   Clipboard.AsText := 'http://ourworld.compuserve.com/homepages/TheProgrammersGuild/Index.htm';
end;

{ URL Label - See Credits at beginning of unit. }
procedure TMainForm.MakeHotSpotLabel(ALabel: TLabel);
begin
  Screen.Cursors[crPGURLHand] := LoadCursor(HInstance, PChar('PGURLHAND'));
  ALabel.Cursor := crPGURLHand;
end;

procedure TMainForm.StatusBarClick(Sender: TObject);
var
  ABtn: TPGCaptionBarOnTopButton;
begin
  ABtn := TPGCaptionBarOnTopButton.Create(Self);
end;

procedure TMainForm.Page7Label5bMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  UpdateStatusBar('View detailed registration information.');
end;

procedure TMainForm.Page8Label2aMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  UpdateStatusBar('Go to The Programmers' + #39 + ' Guild Home Page.');
end;

procedure TMainForm.Page7Label1bMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
begin
  UpdateStatusBar('Go to our online registration service.');
end;

end.
