'
' Compiler Statements 
'
$COMPILE  MEMORY           ' { EXE "?.EXE" | CHAIN "?.PBC" | UNIT "?.PBU" }
$CPU       80386           ' { 8086 | 80286 | 80386}
$COM           0           ' { 0 -> 32767 }
$SOUND         1           ' { 1 -> 4096 }
$STACK     32766           ' { 1536 -> 32766 }
$STRING       32           ' { 1 | 2 | 4 | 8 | 16 | 32 }
$OPTIMIZE SIZE             ' { SIZE | SPEED }
$DIM      ARRAY            ' { ALL | ARRAY | NONE }
$DYNAMIC                   ' { $STATIC | $DYNAMIC | $HUGE }
$ERROR    BOUNDS     OFF   ' { ON | + | OFF | - }
$ERROR    NUMERIC    OFF   ' { ON | + | OFF | - }
$ERROR    OVERFLOW   OFF   ' { ON | + | OFF | - }
$ERROR    PARAM      OFF   ' { ON | + | OFF | - }
$ERROR    STACK      OFF   ' { ON | + | OFF | - }
$EVENT               OFF   ' { ON | + | OFF | - }
$DEBUG    MAP        OFF   ' { ON | + | OFF | - }
$DEBUG    PBDEBUG    OFF   ' { ON | + | OFF | - }
$DEBUG    PATH       OFF   ' { ON | + | OFF | - }
$DEBUG    UNIT       OFF   ' { ON | + | OFF | - }
$OPTION   CNTLBREAK  OFF   ' { ON | + | OFF | - }
$OPTION   GOSUB      OFF   ' { ON | + | OFF | - }
$LIB      ALL        OFF   ' { ON | + | OFF | - }
$LIB      COM        OFF   ' { ON | + | OFF | - }
$LIB      LPT        OFF   ' { ON | + | OFF | - }
$LIB      GRAPH      OFF   ' { ON | + | OFF | - }
$LIB      CGA        OFF   ' { ON | + | OFF | - }
$LIB      EGA        OFF   ' { ON | + | OFF | - }
$LIB      VGA        OFF   ' { ON | + | OFF | - }
$LIB      HERC       OFF   ' { ON | + | OFF | - }
$LIB      FULLFLOAT  OFF   ' { ON | + | OFF | - }
$LIB      IPRINT     OFF   ' { ON | + | OFF | - }
$FLOAT    EMULATE          ' { EMULATE | NPX | PROCEDURE }
'
' Include Statements 
'
$INCLUDE "PUBLICS .INC"    ' all public statements
$INCLUDE "DAS-NB01.INC"    ' nutz 'n boltz #1
$INCLUDE "DAS-NB02.INC"    ' nutz 'n boltz #2
$INCLUDE "DAS-NB03.INC"    ' math package, sound & tunes
''
$INCLUDE "DAS-NBV1.INC"    ' general stuff
$INCLUDE "DAS-NBV2.INC"    ' box routines & screen clearing
'
' Set-up Functions 
'
PUBLIC pProgPath$         ' program's home path
PUBLIC pCollate$          ' CountryCode's collate string for ARRAY SORT

IF pbvCPU < 3 THEN
  CLS
  PRINT "CAN'T RUN THIS PROGRAM ON LESS THAN A 386"
  END
END IF

pProgPath$ = fProgPath$

DIM tCC AS CountryCodeType
LSET tCC = fGetCountry$( 0 )
IF tCC.CountryCode > 0 THEN
  SetDateFormat tCC.DateFormat, tCC.DateSep
  SetTimeFormat tCC.TimeFormat, tCC.TimeSep
  CHR2MID pbvUSINGchrs, 3, tCC.ThousandSep
  CHR2MID pbvUSINGchrs, 4, tCC.DecimalSep
  SetMoneyMask tCC.MoneySymbol, tCC.MoneyFormat, tCC.MoneyDecs
  pCollate$ = fGetCollate$
END IF

CLS
SCREEN 12
GraphicSETUP

SetColorFLAG   1                             ' these values are defaults so
SetMaskAdjust  0                             ' you can/should erase any that
SetForeground 15                             ' you do not use/change.
SetBackground  0                             '
                                             '
fLoadDAScolor                                ' 3-D colors
                                             '
Buttons? = fMouseSETUP?( 2 )                 ' left & right buttons only
EventSetup 10, 200                           ' we'll use events
                                             '
FUNCTION fGetKey% () LOCAL PUBLIC            ' This is what fGetKey%
  LOCAL G%                                   ' looks like when using
                                             ' fEventKey% the only
  DO                                         ' difference is that you
    IF INSTAT THEN                           '
      FUNCTION = CVI( INKEY$ + CHR$(0) )     ' for kbrd and/or mouse
      EXIT FUNCTION                          '
    END IF                                   '
  LOOP UNTIL fMouseGetKey% <> 0              ' change this to > 0
                                             ' clicks only
END FUNCTION                                 '

'
' Program Code 
'


'
' End Program 
'

ByeBye:
  SCREEN 0,,0,0         ' back to text mode
  WIDTH  80,25          ' 80x25 screen
  COLOR  7,0,0          ' normal DOS colors
  LOCATE ,,1            ' cursor on
  CLS                   '
  END                   '
