/*
 *  TEXTFILE.C
 *
 *  Written on 30-Jul-90 by jim nutt.  Changes on 10-Jul-94 by John Dennis.
 *  Released to the public domain.
 *
 *  Handles import and export of text files.
 */

#include "msged.h"
#include "date.h"
#include "main.h"
#include "menu.h"
#include "keys.h"
#include "dialogs.h"
#include "nshow.h"
#include "strextra.h"
#include "memextra.h"

#if defined(PACIFIC)
#include <unixio.h>
#elif defined(SASC)
#include <fcntl.h>
#elif defined(UNIX)
#include <unistd.h>
#else
#include <io.h>
#endif

#define TEXTLEN 2048

LINE *makequote(LINE *, char *);
int wrap(LINE * cl, int x, int y, int rm);
char *getfilename(char *buffer);

void import(LINE * l)
{
    static char fn[PATHLEN];
    static char fname[PATHLEN];
    static char line[TEXTLEN];
    char *temp;
    FILE *fp;
    LINE *n;
    int ret;

    ret = GetString(" Import File ", "Name of file to import?", fn, PATHLEN);

    TTCurSet(1);

    if (!ret)
    {
        return;
    }

    fp = fopen(fn, "r");
    if (fp != NULL)
    {
        if (SW->importfn)
        {
            if (strstr(fn, "\\") || strstr(fn, "/"))
            {
                temp = getfilename(fn);
            }
            else
            {
                temp = strupr(fn);
            }
            strcpy(fname, temp);
            sprintf(line, "   ----- %s begins -----\n", fname);
            l->text = strdup(line);
        }

        while (fgets(line, sizeof line, fp) != NULL)
        {
            if (l->text != NULL)
            {
                n = xcalloc(1, sizeof *n);
                n->prev = l;
                n->next = l->next;

                if (n->next != NULL)
                {
                    n->next->prev = n;
                }

                l->next = n;
                l = n;
            }
            else
            {
                n = l;
            }

            n->text = strdup(line);
            if (strlen(n->text) > (size_t) SW->rm)
            {
                l = n->next;
                wrap(n, 1, maxy, SW->rm);

                if (!l)
                {
                    while (n->next)
                    {
                        n = n->next;
                    }
                }
                else
                {
                    n = l->prev;
                }

                l = n;
            }
        }

        if (SW->importfn)
        {
            if (l->text != NULL)
            {
                n = xcalloc(1, sizeof *n);
                n->prev = l;
                n->next = l->next;

                if (n->next != NULL)
                {
                    n->next->prev = n;
                }

                l->next = n;
                l = n;
            }
            sprintf(line, "   ----- %s ends -----\n", fname);
            l->text = strdup(line);
        }
        fclose(fp);
    }
}

/*
 *  getfilename; Used to isolate the filename on an import so that
 *  it does not import directories into the message. Used only by
 *  import().
 */

char *getfilename(char *buf)
{
    int x, y;
    char tempch[2];
    static char filename[PATHLEN + 1] = "";

    for (x = 0; x <= strlen(buf); x++)
    {
        if (buf[strlen(buf) - x] == '\\' || buf[strlen(buf) - x] == '/')
        {
            break;
        }
    }

    for (y = strlen(buf) - x + 1; y <= strlen(buf); y++)
    {
        tempch[0] = buf[y];
        tempch[1] = '\0';
        if (y == strlen(buf) - x + 1)
        {
            strcpy(filename, tempch);
        }
        else
        {
            strcat(filename, tempch);
        }
    }

    return filename;
}

void export(LINE * f)
{
    FILE *fp;
    char fn[PATHLEN + 1];
    int ret;

    if (ST->outfile)
    {
        strcpy(fn, ST->outfile);
    }
    else
    {
        strcpy(fn, "");
    }

    ret = GetString(" Export File ", "Name of file to export?", fn, PATHLEN);

    if (!ret)
    {
        return;
    }

    release(ST->outfile);
    ST->outfile = strdup(fn);

    if (*fn == '+')
    {
        fp = fopen(fn + 1, "a");
    }
    else
    {
        fp = fopen(fn, "w");
    }

    if (fp == NULL)
    {
        ChoiceBox("", "WARNING: Error opening file", "  Ok  ", NULL, NULL);
        return;
    }

    while (f != NULL)
    {
        if (f->text && (*(f->text) != '\01' || SW->shownotes))
        {
            fputs(f->text, fp);
            if (strchr(f->text, '\n') == NULL)
            {
                fputc('\n', fp);
            }
        }
        f = f->next;
    }

    /* if output is to printer output a formfeed */
    if (isatty(fileno(fp)))
    {
        fputc(12, fp);
    }

    fclose(fp);

    TTCurSet(1);
}

void writetxt(void)
{
    static char *modes[] = {"Text", "Quote", "Msged", NULL};
    static char *ovr[] = {"Append", "Replace", NULL};
    LINE *f = message->text;
    char fn[PATHLEN];
    static int mode = 0;
    int ret;
    FILE *fp;
    char *s;

    if (ST->outfile)
    {
        strcpy(fn, ST->outfile);
    }
    else
    {
        strcpy(fn, "");
    }

    ret = GetString(" Export File ", "Name of file to export?", fn, PATHLEN);

    if (!ret)
    {
        return;
    }

    release(ST->outfile);
    ST->outfile = strdup(fn);

    s = strchr(fn, ',');
    if (s != NULL)
    {
        *s++ = '\0';
    }

    if (s && *s == 't')
    {
        mode = 0;
    }
    else if (s && *s == 'q')
    {
        mode = 1;
    }
    else if ((s && *s == 'm') || !s)
    {
        mode = 2;
    }

    if (*fn == '?')
    {
        mode = DoMenu(61, 2, 69, 4, modes, mode, SELBOX_WRTMODE, "");
        if (mode == -1)
        {
            mode = 0;
            return;
        }
    }

    if (*fn == '+')
    {
        fp = fopen(fn + 1, "a");
    }
    else if (*fn == '?')
    {
        fp = fopen(fn + 1, "r");
        if (fp == NULL)
        {
            fp = fopen(fn + 1, "w");
        }
        else if (isatty(fileno(fp)))
        {
            fclose(fp);
            fp = fopen(fn + 1, "w");
            mode = 0;
        }
        else
        {
            ret = DoMenu(61, 2, 69, 3, ovr, 0, SELBOX_WRTOVER, "");
            if (ret == -1)
            {
                return;
            }

            fclose(fp);
            if (ret)
            {
                fp = fopen(fn + 1, "w");
            }
            else
            {
                fp = fopen(fn + 1, "a");
            }
        }
    }
    else
    {
        fp = fopen(fn, "w");
    }

    if (fp == NULL)
    {
        ChoiceBox("", "WARNING: Error opening file", "  Ok  ", NULL, NULL);
        return;
    }

    if (mode == 0 || (s != NULL && strchr(s, 't') != NULL))
    {
        fprintf(fp, "Date:   %s", itime(message->timestamp));
        fprintf(fp, "\nFrom:   %s", message->isfrom ? message->isfrom : "");
        fprintf(fp, " of %s", show_address(&message->from));
        fprintf(fp, "\nTo:     %s", message->isto ? message->isto : "");

        if (CurArea.netmail)
        {
            fprintf(fp, " of %s", show_address(&message->to));
        }

        fprintf(fp, "\nSubj:   %s", message->subj ? message->subj : "");

        MakeMsgAttrs(fn, &message->attrib, message->scanned, message->times_read);

        fprintf(fp, "\nAttr:   %s", fn);
        fprintf(fp, "\nConf:   %-30s", CurArea.description);
        fprintf(fp, "\n\n");
    }

    if (mode == 1 || (s != NULL && strchr(s, 'q') != NULL))
    {
        makequote(message->text, message->isfrom);
        f = message->text;
    }

    while (f != NULL)
    {
        if (f->text && (*(f->text) != '\01' || SW->shownotes))
        {
            fputs(f->text, fp);
            if (!strchr(f->text, '\n') && (!mode || mode == 1))
            {
                fprintf(fp, "\n");
            }
        }
        f = f->next;
    }

    /* if output is to printer output a formfeed */
    if (isatty(fileno(fp)))
    {
        fputc(12, fp);
    }

    fclose(fp);
    if (mode == 1 || (s != NULL && strchr(s, 'q') != NULL))
    {
        /* reread the old message text */
        set_area(SW->area);
    }
}
