/*
 *  READMAIL.C
 *
 *  Written on 30-Jul-90 by jim nutt.  Changes on 10-Jul-94 by John Dennis.
 *  Released to the public domain.
 *
 *  Handles high-level message I/O.
 */

#include <stdlib.h>
#include <time.h>
#include "msged.h"
#include "date.h"
#include "bmg.h"
#include "main.h"
#include "menu.h"
#include "fecfg145.h"

#if defined(__MSC__) || defined(OS216)
#include <sys/types.h>
#include <sys/timeb.h>
#include <direct.h>
#endif

#if defined(MSDOS) && defined(__TURBOC__)
#include <dir.h>
#endif

#ifdef __WATCOMC__
#if defined(MSDOS) || defined(WINNT)
#include <direct.h>
#endif
#endif

#ifdef PACIFIC
#include <sys.h>
int bdos(int func, unsigned reg_dx, unsigned char reg_al);
#endif

#if defined(MSDOS) || defined(WINNT)
#include <dos.h>
#endif

#ifdef OS2
#define INCL_DOSFILEMGR
#include <fcntl.h>
#endif

#ifdef UNIX
#include <unistd.h>
#endif

#define TEXTLEN 96

#include "normal.h"
#include "strextra.h"
#include "memextra.h"

#ifndef random
#define random(num) (int) (((long) rand() * (num)) / RAND_MAX)
#endif

int setcwd(char *path);
int wrap(LINE * cl, int x, int y, int rm);
int is_quote(char *text);
char *striptwhite(char *s);
void checkrecvd(msg * m, unsigned long n);
void parse_tokens(char *str, char *tokens[], int num);
static void deleteCrapLine(LINE * crap);
static int is_sameaddr(ADDRESS * msg);

extern int set_rcvd;  /* located in msged.c */

#ifdef OS2
static unsigned long setDefaultDisk(unsigned short x);
#endif

static int changeDir(char *path);

LINE *clearbuffer(LINE * buffer)
{
    LINE *curline;

    curline = buffer;
    if (curline != NULL)
    {
        while (curline->next != NULL)
        {
            curline = curline->next;
            if (curline->prev == NULL)
            {
                continue;
            }
            if (curline->prev->text != NULL)
            {
                xfree(curline->prev->text);
            }
            curline->prev->next = NULL;
            xfree(curline->prev);
            curline->prev = NULL;
        }
        if (curline != NULL)
        {
            if (curline->text)
            {
                xfree(curline->text);
            }
            curline->text = NULL;
            xfree(curline);
        }
    }
    return NULL;
}

static void KillTrailingLF(char *text)
{
    char *s;

    if (text == NULL)
    {
        return;
    }

    s = strchr(text, '\n');
    if (s != NULL)
    {
        *s = '\0';
    }
}

msg *readmsg(unsigned long n)
{
    ADDRESS a;
    LINE *l;
    char *tokens[10];
    int headerfin = 0;
    int afound = 0;
    msg *m;
    char *text;
    char *t, *s;
    char *ptmp;
    char tmp[128];
    int goteot = 0;
    int gotsot = 0;

    l = NULL;

    memset(&a, 0, sizeof a);

    m = MsgReadHeader(n, RD_ALL);
    if (m == NULL)
    {
        return NULL;
    }

    stripSoft = 1;
    m->replyarea = NULL;
    while ((text = MsgReadText(n)) != NULL)
    {
        if (*text == '\n' || *text == '\0' || !stricmp(text, "Lines:"))
        {
            headerfin = 1;  /* want to stop looking unix header info */
        }
        if (*text == '\01')
        {
            switch (*(text + 1))
            {
            case 'A':
                if (strncmp(text + 1, "AREA:", 5) != 0)
                {
                    break;
                }
                s = text + 6;

                while (isspace(*s))
                {
                    s++;
                }

                release(m->replyarea);
                m->replyarea = xstrdup(s);
                KillTrailingLF(m->replyarea);
                break;

            case 'M':
                if (strncmp(text + 1, "MSGID:", 6) != 0)
                {
                    break;
                }
                s = text + 7;

                while (isspace(*s))
                {
                    s++;
                }

                release(m->msgid);
                m->msgid = xstrdup(s);
                KillTrailingLF(m->msgid);
                break;

            case 'R':
                if (strncmp(text + 1, "REPLY:", 6) != 0)
                {
                    break;
                }
                s = text + 7;

                while (isspace(*s))
                {
                    s++;
                }

                if (arealist[SW->area].msgtype != QUICK)
                {
                    release(m->reply);
                    m->reply = xstrdup(s);
                    KillTrailingLF(m->reply);
                }
                break;

            case 'E':
                if (strncmp(text + 1, "EOT:", 4) == 0)
                {
                    goteot = 1;
                    if (gotsot && !(SW->seenbys || SW->shownotes))
                    {
                        m->soteot = 1;
                    }
                }
                break;

            case 'S':
                if (strncmp(text + 1, "SOT:", 4) == 0)
                {
                    gotsot = 1;
                    stripSoft = 0;
                }
                break;

            case 'F':
                if (strncmp(text + 1, "FMPT", 4) != 0)
                {
                    break;
                }
                s = text + 5;
                m->from.point = atoi(s + 1);
                break;

            case 'T':
                if (strncmp(text + 1, "TOPT", 4) != 0)
                {
                    break;
                }
                s = text + 5;
                m->to.point = atoi(s + 1);
                break;

            case 'D':
                if (strncmp(text + 1, "DOMAIN", 6) != 0)
                {
                    break;
                }

                s = text + 7;
                strcpy(tmp, s);
                memset(tokens, 0, sizeof(tokens));
                parse_tokens(tmp, tokens, 4);

                if (!tokens[3])
                {
                    break;
                }

                memset(&a, 0, sizeof a);
                a = parsenode(tokens[1]);
                if (a.fidonet)
                {
                    release(m->to.domain);
                    m->to = a;
                    m->to.domain = xstrdup(tokens[0]);
                }
                memset(&a, 0, sizeof a);
                a = parsenode(tokens[3]);
                if (a.fidonet)
                {
                    release(m->from.domain);
                    m->from = a;
                    m->from.domain = xstrdup(tokens[2]);
                }
                break;

            case 'I':
                if (strncmp(text + 1, "INTL", 4) != 0)
                {
                    break;
                }

                s = text + 5;
                strcpy(tmp, s + 1);
                memset(tokens, 0, sizeof(tokens));
                parse_tokens(tmp, tokens, 2);

                if (!tokens[1])
                {
                    break;
                }

                memset(&a, 0, sizeof a);
                a = parsenode(tokens[0]);
                if (a.fidonet)
                {
                    release(m->to.domain);
                    m->to = a;
                }
                memset(&a, 0, sizeof a);
                a = parsenode(tokens[1]);
                if (a.fidonet)
                {
                    release(m->from.domain);
                    m->from = a;
                }
                break;
            }

            if (!SW->shownotes)
            {
                release(text);
                continue;
            }
        }

        if (*text == 'S')
        {
            if (strncmp(text, "SEEN-BY:", 8) == 0 &&
              !(SW->seenbys || SW->shownotes) && (!gotsot || goteot))
            {
                release(text);
                continue;
            }
        }

        if (goteot && *text == '\n' && !(SW->seenbys || SW->shownotes))
        {
            release(text);
            continue;
        }

        /* from Roland Gautschi */

        if (SW->tabexpand && strchr(text, '\t') != NULL)
        {
            do
            {
                ptmp = xstrdup(text);
                release(text);

                text = xmalloc(strlen(ptmp) + SW->tabsize);
                t = strchr(ptmp, '\t');

                /* characters before \t */

                strncpy(text, ptmp, (size_t) (t - ptmp));

                /* replace \t with spaces */

                memset(text + (size_t) (t - ptmp), ' ', SW->tabsize);

                /* copy the rest */

                strcpy(text + (size_t) (t - ptmp) + SW->tabsize, t + 1);
                xfree(ptmp);
            }
            while (strchr(text, '\t') != NULL);
        }

        if (CurArea.echomail)
        {
            if (afound == 0 && strlen(text) > 10 && *(text + 1) == '*')
            {
                if (!strncmp(text, " * Origin:", 10))
                {
                    /* probably the origin line */

                    s = strrchr(text, '(');
                    if (s != NULL)
                    {
                        while (*s && !isdigit(*s) && *s != ')')
                        {
                            s++;
                        }

                        if (isdigit(*s))
                        {
                            m->from = parsenode(s);
                        }
                    }
                    else
                    {
                        m->from.notfound = 1;
                    }
                }
            }
        }

        if (strncmp(text, "---", 3) == 0 && strncmp(text, "----", 4) != 0 &&
          !(SW->seenbys || SW->shownotes) && (!gotsot || goteot))
        {
            release(text);
            continue;
        }

        if (strncmp(text, " * Origin:", 10) == 0 &&
          !(SW->seenbys || SW->shownotes) &&
          (!gotsot || goteot))
        {
            release(text);
            continue;
        }

        if ((CurArea.uucp || CurArea.news) && headerfin == 0)
        {
            char *s;

            if (CurArea.uucp)
            {
                if (strncmp(text, "To:", 3) == 0)
                {
                    s = strchr(text, ' ');
                    m->to.fidonet = 0;
                    m->to.internet = 0;
                    m->to.bangpath = 0;
                    m->to.notfound = 0;
                    while (isspace(*s))
                    {
                        s++;
                    }
                    if (strchr(s, '@') != NULL)
                    {
                        m->to.internet = 1;
                    }
                    else
                    {
                        m->to.bangpath = 1;
                    }
                    release(m->to.domain);
                    m->to.domain = xstrdup(s);
                    striptwhite(m->to.domain);
                    if (!SW->shownotes)
                    {
                        release(text);
                        continue;
                    }
                }
            }

            if (strncmp(text, "From:", 5) == 0)
            {
                s = strrchr(text, '(');
                if (s == NULL)
                {
                    release(m->isfrom);
                    m->isfrom = xstrdup("UUCP");
                }
                else
                {
                    *s = '\0';
                    t = strrchr(s + 1, ')');
                    if (t != NULL)
                    {
                        *t = '\0';
                    }
                    m->isfrom = xstrdup(s + 1);
                }
                s = strchr(text, ' ') + 1;
                m->from.fidonet = 0;
                m->from.internet = 0;
                m->from.bangpath = 0;
                m->from.notfound = 0;
                while (isspace(*s))
                {
                    s++;
                }
                if (strchr(s, '@') != NULL)
                {
                    m->from.internet = 1;
                }
                else
                {
                    m->from.bangpath = 1;
                }
                release(m->from.domain);
                m->from.domain = xstrdup(s);
                striptwhite(m->from.domain);
                if (!SW->shownotes)
                {
                    release(text);
                    continue;
                }
            }
        }

        if (*text != '\01' || SW->shownotes)
        {
            if (l == NULL)
            {
                l = xcalloc(1, sizeof(LINE));
                m->text = l;
                l->next = l->prev = NULL;
            }
            else
            {
                l->next = xcalloc(1, sizeof(LINE));
                if (l->next == NULL)
                {
                    xfree(text);
                    break;
                }
                l->next->next = NULL;
                l->next->prev = l;
                l = l->next;
            }

            l->block = 0;
            l->text = text;
            l->hide = (*text == '\01');

            if (is_quote(text))
            {
                l->quote = 1;
            }
            else
            {
                l->quote = 0;
            }

            if (l->quote)
            {
                if (strlen(l->text) > maxx)
                {
                    wrap(l, 1, maxy, maxx);
                    while (l->next)
                    {
                        l = l->next;
                    }
                }
            }
            else
            {
                if (*text != '\01' && *text != '\n' && strlen(text) > maxx)
                {
                    wrap(l, 1, maxy, maxx);
                    while (l->next)
                    {
                        l = l->next;
                    }
                }
            }
        }
        else
        {
            release(text);
        }
    }

    MsgClose();

    if (set_rcvd)
    {
        checkrecvd(m, n);
    }

    return m;
}

/*
 *  checkrecvd; Checks to see if a message has been recieved. If so,
 *  reads the message header again (avoiding translations done in the
 *  original readinf process) and then writes the header to the message
 *  base.
 */

void checkrecvd(msg * m, unsigned long n)
{
    msg *mn;

    if (m->attrib.rcvd)
    {
        return;
    }

    m->times_read++;

    if (stricmp(ST->username, m->isto) == 0 && is_sameaddr(&m->to))
    {
        mn = MsgReadHeader(n, RD_HEADER);
        if (mn == NULL)
        {
            return;
        }
        mn->attrib.rcvd = 1;
        m->attrib.rcvd = 1;
        m->newrcvd = 1;
        mn->times_read++;
        MsgWriteHeader(mn, WR_HEADER);
        dispose(mn);
    }
}

static int is_sameaddr(ADDRESS * msg)
{
    if (!CurArea.netmail)
    {
        /* we only care about the address in netmail areas */
        return 1;
    }
    if (msg->zone != CurArea.addr.zone)
    {
        return 0;
    }
    if (msg->net != CurArea.addr.net)
    {
        return 0;
    }
    if (msg->node != CurArea.addr.node)
    {
        return 0;
    }
    if (msg->point != CurArea.addr.point)
    {
        return 0;
    }
    return 1;
}

/*
 *  Clears a message only - wipes the slate clean.
 */

void clearmsg(msg * m)
{
    if (m == NULL)
    {
        return;
    }

    /* kill the header stuff */

    release(m->reply);
    release(m->msgid);
    release(m->isfrom);
    release(m->isto);
    release(m->subj);
    release(m->to.domain);
    release(m->from.domain);

    if (m->text)
    {
        /* kill the text */
        m->text = clearbuffer(m->text);
    }

    /* clear the whole lot */
    memset(m, 0, sizeof *m);

    /* set the defaults */
    m->attrib.priv = CurArea.priv;
    m->attrib.crash = CurArea.crash;
    m->attrib.hold = CurArea.hold;
    m->attrib.direct = CurArea.direct;
    m->attrib.killsent = CurArea.killsent;
    m->attrib.local = 1;
}

int setcwd(char *path)
{
    char *p;

    p = strchr(path, ':');
    if (p == NULL)
    {
        p = path;
    }

    if (*p == ':')
    {
        p++;
#if defined(OS2)
        setDefaultDisk((unsigned short)(toupper(*path) - 'A' + 1));
#elif defined(MSDOS) && !defined(__FLAT__)
        bdos(14, toupper(*path) - 'A', 0);
#elif defined(__FLAT__)
        {
            unsigned dummy;
            _dos_setdrive(toupper(*path) - 'A' + 1, &dummy);
        }
#endif
    }

    return changeDir(p);
}

int isleap(int year)
{
    return year % 400 == 0 || (year % 4 == 0 && year % 100 != 0);
}

unsigned long unixtime(const struct tm *tm)
{
    int year, i;
    unsigned long result;

    result = 0UL;
    year = tm->tm_year + 1900;

    /* traverse through each year */

    for (i = 1970; i < year; i++)
    {
        result += 31536000UL;  /* 60s * 60m * 24h * 365d = 31536000s */
        if (isleap(i))
        {
            /* it was a leap year; add a day's worth of seconds */
            result += 86400UL;  /* 60s * 60m * 24h = 86400s */
        }
    }

    /*
     *  Traverse through each day of the year, adding a day's worth
     *  of seconds each time.
     */

    for (i = 0; i < tm->tm_yday; i++)
    {
        result += 86400UL;  /* 60s * 60m * 24h = 86400s */
    }

    /* now add the number of seconds remaining */

    result += 3600UL * tm->tm_hour;
    result += 60UL * tm->tm_min;
    result += (unsigned long) tm->tm_sec;

    return result;
}

unsigned long sec_time(void)
{
    time_t now;
    struct tm *tm;
    now = time(NULL);
    tm = localtime(&now);
    return unixtime(tm);
}

/*
 *  Inserts a line after the passed line and returns a pointer to it.
 */

static LINE *InsertAfter(LINE * l, char *text)
{
    LINE *nl;

    nl = xcalloc(1, sizeof(LINE));
    nl->text = xstrdup(text);

    if (l == NULL)
    {
        return nl;
    }

    nl->next = l->next;
    nl->prev = l;
    l->next = nl;
    if (nl->next)
    {
        nl->next->prev = nl;
    }

    return nl;
}

/*
 *  Gets the origin line to use.
 */

static char *GetFastEchoOrigin(int board)
{
    FILE *fp;
    CONFIG feconfig;
    Area fearea;
    ExtensionHeader feexthdr;
    static OriginLines feorigin;
    int cnt, found;

    fp = fopen(ST->fecfgpath, "rb");
    if (fp == NULL)
    {
        return NULL;
    }

    if (fread(&feconfig, sizeof feconfig, 1, fp) != 1)
    {
        return NULL;
    }

    fseek(fp, sizeof feconfig + feconfig.offset + feconfig.NodeCnt *
      feconfig.NodeRecSize, SEEK_SET);

    do
    {
        if (fread(&fearea, sizeof fearea, 1, fp) != 1)
        {
            return NULL;
        }
    }
    while (board != fearea.board);

    cnt = 0;
    found = 0;

    fseek(fp, sizeof feconfig, SEEK_SET);
    while (!found)
    {
        fread(&feexthdr, sizeof feexthdr, 1, fp);
        if (feexthdr.type == EH_ORIGINS)
        {
            do
            {
                if (fread(&feorigin, sizeof feorigin, 1, fp) != 1)
                {
                    return NULL;
                }
                cnt++;
            }
            while (cnt <= ((fearea.flags.flags & 0x1f00) >> 8));
            found = 1;
        }
        else
        {
            fseek(fp, feexthdr.offset, SEEK_CUR);
        }
    }

    fclose(fp);

    if (feorigin.line && *feorigin.line != '\0')
    {
        return feorigin.line;
    }
    else
    {
        return NULL;
    }
}

static void GetOrigin(char *origin)
{
    FILE *fp;
    char path[255];

    if (!SW->override)
    {
        if (CurArea.msgtype == SQUISH)
        {
            sprintf(path, "%s.sqo", CurArea.path);
        }
        else
        {
            sprintf(path, "%s\\origin", CurArea.path);
        }

        fp = fopen(path, "r");
        if (fp != NULL)
        {
            int i, orgnum, orgcnt;

            i = 0;
            orgnum = 0;
            orgcnt = 0;

            do
            {
                *origin = '\0';
                fgets(origin, 65, fp);
                if (*origin)
                {
                    orgcnt++;
                }
            }
            while (!feof(fp));

            orgnum = random(orgcnt) + 1;

            rewind(fp);

            do
            {
                *origin = '\0';
                fgets(origin, 65, fp);
                if (*origin)
                {
                    i++;
                }
                if (i == orgnum)
                {
                    break;
                }
            }
            while (!feof(fp));

            fclose(fp);
        }
        else
        {
            if (ST->origin != NULL)
            {
                strcpy(origin, ST->origin);
            }
            else
            {
                strcpy(origin, ST->username);
            }
            if (CurArea.msgtype == QUICK && areas_type == FASTECHO)
            {
                char *feorigin;
                feorigin = GetFastEchoOrigin(CurArea.board);
                if (feorigin != NULL)
                {
                    strcpy(origin, feorigin);
                }
            }
        }
    }
    else
    {
        if (ST->origin != NULL)
        {
            strcpy(origin, ST->origin);
        }
        else
        {
            strcpy(origin, ST->username);
        }
    }
    striptwhite(origin);
}

static void InvalidateKludges(msg * m)
{
    LINE *line;

    line = m->text;
    while (line != NULL)
    {
        char *p;
        p = line->text;
        if (p != NULL)
        {
            if (*p == '\01')
            {
                *p = '@';
            }
            else if (strstr(p, "SEEN-BY: ") == p)
            {
                *(p + 4) = '+';
            }
            else if (strstr(p, "---\n") == p || strstr(p, "--- ") == p ||
              strstr(p, " * Origin: ") == p)
            {
                *(p + 1) = '+';
            }
        }
        line = line->next;
    }
}

static void StripKludges(msg * m)
{
    LINE *line;
    int got_origin, got_tear, got_text;

    /* traverse forwards through linked list until the end */

    line = m->text;
    while (line->next != NULL)
    {
        line = line->next;
    }

    /* now go backwards, removing any unwanted stuff */

    got_origin = 0;
    got_tear = 0;
    got_text = 0;

    while (line != NULL)
    {
        char *p;

        p = line->text;
        if (p != NULL)
        {
            if (strstr(p, "\01MSGID: ") == p || strstr(p, "\01REPLY: ") == p ||
              strstr(p, "\01FLAGS ") == p || strstr(p, "\01PID: ") == p ||
              strstr(p, "\01SOT:") == p || strstr(p, "\01EOT:") == p)
            {
                *p = '\0';
            }
            else if (CurArea.netmail)
            {
                if (strstr(p, "\01INTL ") == p || strstr(p, "\01TOPT ") == p ||
                  strstr(p, "\01FMPT ") == p || strstr(p, "\01DOMAIN ") == p ||
                  strstr(p, "\01Via ") == p)
                {
                    *p = '\0';
                }
            }
            else if (!CurArea.netmail)
            {
                if (strstr(p, "SEEN-BY: ") == p || strstr(p, "\01PATH: ") == p)
                {
                    *p = '\0';
                }
                else if (!got_text && !got_origin && strstr(p, " * Origin: ") == p)
                {
                    *p = '\0';
                    got_origin = 1;
                }
                else if (!got_text && !got_tear && (strstr(p, "---\n") == p ||
                  strstr(p, "--- ") == p))
                {
                    *p = '\0';
                    got_tear = 1;
                }
                else if (!got_text && (*p == '\n' || *p == '\r'))
                {
                    *p = '\0';
                }
                else if (!got_text && *p != '\0' && *p != '\n' && *p != '\r')
                {
                    got_text = 1;
                }
            }
        }

        line = line->prev;
    }
}

/*
 *  Sequence of events:
 *
 *  Original address is saved (what is displayed);
 *  Domain gates are checked for and address is modified if one found;
 *  if no domain gates, search for UUCP gate && mod address if found.
 *  check INTL
 *  check MSGID
 *  check REPLY
 *  do PID if one,
 *  If we found domain gate, do DOMAIN with original saved addresses.
 *  if we found UUCP, then do a "to:" kludge.
 */

/*
 *  Writes a message to disk.
 */

int writemsg(msg * m)
{
    LINE *curr, *l, *ufrom, *uto, *xblank, *xtear, *xorigin;
    ADDRESS to;
    ADDRESS from;
    unsigned long n;            /* UMSGID msgnum */
    unsigned long length;       /* length in bytes of the message */
    char text[255];             /* buffer useage */
    char origin[255];           /* out origin line */
    char *uucp_from;            /* saved UUCP from address */
    char *uucp_to;              /* saved UUCP to address */
    int domain_gated, uucp_gated;
    char *s;
    int i, abortWrite;
    static unsigned long now = 0L;

    domain_gated = 0;
    uucp_gated = 0;
    length = 0;
    n = m->msgnum;
    curr = NULL;
    uto = NULL;
    ufrom = NULL;
    uucp_from = NULL;
    uucp_to = NULL;
    xorigin = NULL;
    xtear = NULL;
    xblank = NULL;

    if (now == 0L)
    {
        now = sec_time();
    }

    if (m->invkludges)
    {
        InvalidateKludges(m);
    }
    else if (!m->rawcopy)
    {
        StripKludges(m);
    }

    if (!m->rawcopy)
    {
        /* save the original address */

        to = m->to;
        from = m->from;

        /* do domain gating */

        if ((SW->gate == GDOMAINS || SW->gate == BOTH) && SW->domains && m->to.domain)
        {
            /*
             *  If we have two domains and they're different, then we want to
             *  gate. If we have a to: domain and no from: domain, then we
             *  still may want to gate.  If we don't have a to: domain, then
             *  we don't want to gate the message (we assume it's destined to
             *  our own network).
             */

            if (m->to.domain || (m->from.domain && m->to.domain &&
              stricmp(m->from.domain, m->to.domain)))
            {
                for (i = 0; i < SW->domains; i++)
                {
                    if (!stricmp(domain_list[i].domain, m->to.domain))
                    {
                        domain_gated = 1;

                        if (m->attrib.crash || m->attrib.crash)
                        {
                            int ret;

                            ret = ChoiceBox(" Crash ", "Crash message to?",
                              "Domain Gate", "Destination Node", NULL);

                            if (ret == ID_ONE)
                            {
                                m->to = domain_list[i];
                                if (domain_list[i].domain)
                                {
                                    m->to.domain = xstrdup(domain_list[i].domain);
                                }
                            }
                        }
                        else
                        {
                            m->to = domain_list[i];
                            if (domain_list[i].domain)
                            {
                                m->to.domain = xstrdup(domain_list[i].domain);
                            }
                        }
                        break;
                    }
                }
            }
        }

        /* do uucp gating */

        if (m->to.internet || m->to.bangpath)
        {
            uucp_gated = 1;
            uucp_to = m->to.domain;
            m->to = uucp_gate;
            if (uucp_gate.domain)
            {
                m->to.domain = xstrdup(uucp_gate.domain);
            }
        }

        if (m->from.internet || m->from.bangpath)
        {
            uucp_gated = 1;
            uucp_from = m->from.domain;
            m->from = uucp_gate;
            if (uucp_gate.domain)
            {
                m->from.domain = xstrdup(uucp_gate.domain);
            }
        }

        /* do the netmail stuff */

        if (CurArea.netmail || CurArea.uucp)
        {
            if (m->from.zone != m->to.zone || m->from.zone != thisnode.zone)
            {
                sprintf(text, "\01INTL %d:%d/%d %d:%d/%d\r", m->to.zone,
                  m->to.net, m->to.node, m->from.zone, m->from.net, m->from.node);
                curr = InsertAfter(curr, text);
            }
            if (m->to.point)
            {
                sprintf(text, "\01TOPT %d\r", m->to.point);
                curr = InsertAfter(curr, text);
            }
            if (m->from.point)
            {
                sprintf(text, "\01FMPT %d\r", m->from.point);
                curr = InsertAfter(curr, text);
            }
        }

        /* these babies go everywhere */

        if (m->new)
        {
            if (SW->msgids)
            {
                sprintf(text, "\01MSGID: %s %08lx\r", show_address(&from), now++);
                curr = InsertAfter(curr, text);
            }
        }
        else
        {
            if (m->msgid)
            {
                sprintf(text, "\01MSGID: %s\r", m->msgid);
                curr = InsertAfter(curr, text);
            }
        }

        if (m->reply && (!m->new || SW->msgids))
        {
            sprintf(text, "\01REPLY: %s\r", m->reply);
            curr = InsertAfter(curr, text);
        }

        if (SW->echoflags && CurArea.echomail)
        {
            char flags[255];

            /* FLAGS control line */

            *flags = '\0';
            if (m->attrib.priv)
            {
                strcat(flags, " PVT");
            }
            if (m->attrib.crash)
            {
                strcat(flags, " CRA");
            }
            if (m->attrib.attach)
            {
                strcat(flags, " FIL");
            }
            if (m->attrib.killsent)
            {
                strcat(flags, " K/S");
            }
            if (m->attrib.hold)
            {
                strcat(flags, " HLD");
            }
            if (m->attrib.direct)
            {
                strcat(flags, " DIR");
            }
            if (m->attrib.freq)
            {
                strcat(flags, " FRQ");
            }
            if (m->attrib.rreq)
            {
                strcat(flags, " RRQ");
            }
            if (m->attrib.rcpt)
            {
                strcat(flags, " CFM");
            }
            if (*flags)
            {
                sprintf(text, "\01FLAGS%s\r", flags);
                curr = InsertAfter(curr, text);
            }
        }

        if (SW->usepid || CurArea.netmail)
        {
            sprintf(text, "\01PID: %s %s\r", PROG, PIDVER PIDBETA);
            curr = InsertAfter(curr, text);
        }

        /* domain gating */

        if (domain_gated)
        {
            sprintf(text, "\01DOMAIN %s %d:%d/%d.%d %s %d:%d/%d.%d\r",
              to.domain, to.zone, to.net, to.node, to.point, from.domain,
              from.zone, from.net, from.node, from.point);
            curr = InsertAfter(curr, text);
        }

        if (SW->soteot)
        {
            strcpy(text, "\01SOT:\r");
            curr = InsertAfter(curr, text);
        }

        if (uucp_gated)
        {
            int cr = 0;  /* we want to insert a \n after header info */

            if (uucp_from)
            {
                sprintf(text, "From: %s\r", uucp_from);
                curr = InsertAfter(curr, text);
                ufrom = curr;
                cr = 1;
            }

            if (uucp_to)
            {
                sprintf(text, "To: %s\r", uucp_to);
                curr = InsertAfter(curr, text);
                uto = curr;
                cr = 1;
            }

            if (cr == 1)
            {
                strcpy(text, "\n");
                curr = InsertAfter(curr, text);
            }
        }

        /*
         *  Actually assign the kludges we just created to the message body
         *  (before the text).
         */

        if (curr)
        {
            curr->next = m->text;
            if (m->text)
            {
                m->text->prev = curr;
            }

            while (curr->prev)
            {
                curr = curr->prev;
            }

            m->text = curr;
        }
    }

    l = m->text;
    while (l)
    {
        if (l->text == NULL)
        {
            l->text = xstrdup("\r");
        }

        if (*l->text)
        {
            s = strrchr(l->text, '\n');
            if (s != NULL)
            {
                *s = '\r';
            }
            else
            {
                char *text;

                text = xmalloc(strlen(l->text) + 2);
                strcpy(text, l->text);
                if (l->quote)
                {
                    strcat(text, "\r");
                }
                else
                {
                    if (l->next && *(l->next->text) == '\n' &&
                      text[strlen(text) - 1] != '\r')
                    {
                        strcat(text, "\r");
                    }
                    else
                    {
                        if (!isspace(*(text + strlen(text) - 1)))
                        {
                            strcat(text, " ");
                        }
                    }
                }
                release(l->text);
                l->text = text;
            }
        }
        l = l->next;
    }

    /* find the end of the message */

    curr = m->text;
    while (curr->next)
    {
        curr = curr->next;
    }

    if (!m->rawcopy)
    {
        if (SW->soteot)
        {
            strcpy(text, "\01EOT:\r");
            curr = InsertAfter(curr, text);
        }

        if (CurArea.netmail && SW->netmailvia)
        {
            time_t td;
            char time_str[80];

            td = time(NULL);
            strftime(time_str, 80, "%a %b %d %Y at %H:%M UTC", gmtime(&td));
            sprintf(text, "\01Via " PROG " " PIDVER PIDBETA " %s, %s\r",
              show_address(&from), time_str);
            curr = InsertAfter(curr, text);
        }

        if (CurArea.echomail)
        {
            if (*curr->text != '\r')
            {
                strcpy(text, "\r");
                curr = InsertAfter(curr, text);
                xblank = curr;
            }

            /* add the tearline */

            if (SW->usepid)
            {
                sprintf(text, "---\r");
            }
            else
            {
                sprintf(text, "--- %s %s\r", PROG, VERSION CLOSED);
            }

            curr = InsertAfter(curr, text);
            xtear = curr;

            /* add the origin line */

            GetOrigin(origin);
            sprintf(text, " * Origin: %s (%s)\r", origin,
              SW->domainorigin ? show_address(&from) : show_4d(&from));

            curr = InsertAfter(curr, text);
            xorigin = curr;
        }
    }

    /* we've made the new message up, now return it's length */

    l = m->text;
    while (l)
    {
        length += strlen(l->text);
        l = l->next;
    }

    if (!m->rawcopy)
    {
        /* remap point originated crashmail */

        if (!m->attrib.direct && !m->attrib.crash && m->from.point &&
          SW->pointnet != 0 && CurArea.netmail)
        {
            m->from.net = SW->pointnet;
            m->from.node = m->from.point;
            m->from.point = 0;
        }

        /* do any required zone gating */

        if (CurArea.addr.zone != m->to.zone && !m->attrib.direct &&
          !m->attrib.crash && CurArea.netmail && (SW->gate == GZONES ||
          SW->gate == BOTH))
        {
            m->to.node = m->to.zone;
            m->to.zone = CurArea.addr.zone;
            m->to.net = CurArea.addr.zone;
        }
    }

    abortWrite = 0;
    while (MsgWriteHeader(m, WR_ALL) == ERR_OPEN_MSG && !abortWrite)
    {
        int ret;

        ret = ChoiceBox(" Error! ", "Could not write message!",
          "Retry", "Cancel", NULL);

        if (ret == ID_TWO)
        {
            abortWrite = 1;
        }
    }

    if (!abortWrite)
    {
        l = m->text;
        while (l)
        {
            if (l->text && *l->text != '\0')
            {
                MsgWriteText(l->text, n, length);
            }

            /*
             *  The \r's have to be turned back into \n's because the
             *  message might be a CC: and so be needed again.
             */

            s = strrchr(l->text, '\r');
            if (s != NULL)
            {
                *s = '\n';
            }

            l = l->next;
        }

        MsgWriteText(NULL, n, length);
        MsgClose();
    }

    CurArea.new = 1;

    /*
     *  Clean up. If this message is a CC, then we don't want this
     *  temporary information to remain.
     */

    if (uucp_from)
    {
        release(uucp_from);
        deleteCrapLine(ufrom);
    }

    if (uucp_to)
    {
        release(uucp_to);
        deleteCrapLine(uto);
    }

    deleteCrapLine(xblank);
    deleteCrapLine(xtear);
    deleteCrapLine(xorigin);

    if (abortWrite)
    {
        return FALSE;
    }
    else
    {
        return TRUE;
    }
}

static void deleteCrapLine(LINE * crap)
{
    if (crap != NULL)
    {
        if (crap->prev != NULL)
        {
            crap->prev->next = crap->next;
        }
        if (crap->next != NULL)
        {
            crap->next->prev = crap->prev;
        }
        release(crap->text);
        release(crap);
    }
}

#ifdef OS2

#include <os2.h>

static unsigned long setDefaultDisk(unsigned short x)
{
#ifdef OS216
    return DosSelectDisk(x);
#else
    return DosSetDefaultDisk(x);
#endif
}

static int changeDir(char *path)
{
#ifdef OS216
    return chdir(path);
#else
    return DosSetCurrentDir((PSZ) path);
#endif
}

void mygetcwd(char *buf, int len)
{
#ifdef OS216
    getcwd(buf, len);
#else
    unsigned long ulen;
    ulen = len;
    DosQueryCurrentDir(0, (PSZ) buf, &ulen);
#endif
}

#else

static int changeDir(char *path)
{
    return chdir(path);
}

void mygetcwd(char *buf, int len)
{
#ifndef PACIFIC
    getcwd(buf, len);
#else
    getcwd(buf);
#endif
}

#endif
