{
  WSnmpMIB.Pas
  Copyright 1996 by MG-SOFT Corporation. All rights reserved.

  WSnmpMIB Delphi file
  Converted by MG-SOFT d.o.o.
    E-mail: info@mg-soft.si
    Web URL: http://www.mg-soft.si/

  Source for conversion:
    WSNMPMIB.H file
}
unit WSnmpMib;

interface

uses WinTypes, WinProcs, WinSnmp;

  type
  { windows related types }
  HWSM_NODE = THandle;            LPHWSM_NODE = PHandle;
  HWSM_LISTELEMENT = THandle;     LPHWSM_LISTELEMENT = PHandle;

  const
    { status values }
    WSM_STATUS_MANDATORY	       	= 1;
    WSM_STATUS_OPTIONAL			= 2;
    WSM_STATUS_OBSOLETE			= 3;
    WSM_STATUS_DEPRECATED	        = 4;
    WSM_STATUS_CURRENT			= 5;

    { access values }
    WSM_ACCESS_READONLY			= 1;
    WSM_ACCESS_READWRITE	       	= 2;
    WSM_ACCESS_WRITEONLY	       	= 3;
    WSM_ACCESS_NOTACCESSIBLE		= 4;
    WSM_ACCESS_READCREATE	        = 5;

    { flag values }
    WSM_YES_FLAG		       	= 1;
    WSM_NO_FLAG				= 2;

    { error codes returned by WsmGetLastError(), so as not to    }
    { conflict with the error codes from winSNMP                 }
    WSM_NODE_UNKNOWN                   	= 200;
    WSM_NODE_AMBIGUOUS                 	= 201;
    WSM_NODE_NONE                      	= 202;
    WSM_NODE_NOINFO                    	= 203;
    WSM_NODE_TRUNCATED                	= 204;
    WSM_LISTELEMENT_UNKNOWN            	= 205;
    WSM_LISTELEMENT_AMBIGUOUS          	= 206;
    WSM_LISTELEMENT_NONE               	= 207;
    WSM_LISTELEMENT_NOINFO             	= 208;
    WSM_LISTELEMENT_TRUNCATED          	= 209;
    WSM_MODULE_NOTLOADED               	= 210;
    WSM_MODULE_NOTUNLOADED             	= 211;

    { information identifiers }
    WSM_INFO_TYPE                      	= 1;
    WSM_INFO_NAME                      	= 2;
    WSM_INFO_OID                       	= 3;
    WSM_INFO_LAST_UPDATED              	= 4;
    WSM_INFO_ORGANIZATION              	= 5;
    WSM_INFO_CONTACT                   	= 6;
    WSM_INFO_DESCRIPTION               	= 7;
    WSM_INFO_REVISIONS                 	= 8;
    WSM_INFO_STATUS                    	= 9;
    WSM_INFO_REFERENCE                 	= 10;
    WSM_INFO_SYNTAX                    	= 11;
    WSM_INFO_SYNTAXSIZES               	= 12;
    WSM_INFO_SYNTAXVALS                	= 13;
    WSM_INFO_TEXTCONV_NAME             	= 14;
    WSM_INFO_TEXTCONV_DISPHINT         	= 15;
    WSM_INFO_TEXTCONV_STATUS           	= 16;
    WSM_INFO_TEXTCONV_DESCR            	= 17;
    WSM_INFO_TEXTCONV_REFER            	= 18;
    WSM_INFO_UNITS                     	= 19;
    WSM_INFO_MAXACCESS                 	= 20;
    WSM_INFO_INDEXES                   	= 21;
    WSM_INFO_AUGMENTS                  	= 22;
    WSM_INFO_DEFVAL                    	= 23;
    WSM_INFO_OBJECTS                   	= 24;
    WSM_INFO_ENTERPRISE                	= 25;
    WSM_INFO_INTVALUE                  	= 26;
    { WSM_INFO_OBJECTS                     = 27;}
    WSM_INFO_MCMODULES                 	= 28;
    WSM_INFO_PRODUCTREL                	= 29;
    WSM_INFO_ACMODULES                 	= 30;
    WSM_INFO_REVISION                  	= 31;
    WSM_INFO_IMPLIED                   	= 32;
    WSM_INFO_MINSIZE                   	= 33;
    WSM_INFO_MAXSIZE                   	= 34;
    WSM_INFO_VALUEINT                  	= 35;
    WSM_INFO_VALUELABEL                	= 36;
    WSM_INFO_MANDGROUPS                	= 37;
    WSM_INFO_MCOMPS                    	= 38;
    WSM_INFO_GROUPTYPE                 	= 39;
    WSM_INFO_OBJECTTYPE                	= 40;
    WSM_INFO_WRITESYNTAX               	= 41;
    WSM_INFO_WSYNTAXSIZES              	= 42;
    WSM_INFO_WSYNTAXVALS               	= 43;
    WSM_INFO_MINACCESS                 	= 44;
    WSM_INFO_SUPPORT                   	= 45;
    WSM_INFO_INCLUDES                  	= 46;
    WSM_INFO_VARIABLES                 	= 47;
    WSM_INFO_ACCESS                    	= 48;
    WSM_INFO_CREATIONS                 	= 49;
    WSM_INFO_MODULE                  	= 50;

    { Node types }
    WSM_MODULE_IDENTITY                	= 1;
    WSM_OBJECT_IDENTITY                	= 2;
    WSM_OBJECT_TYPE                    	= 3;
    WSM_NOTIFICATION_TYPE              	= 4;
    WSM_OBJECT_GROUP                   	= 5;
    WSM_MODULE_COMPLIANCE              	= 6;
    WSM_AGENT_CAPABILITIES             	= 7;

    { ListElement types }
    WSM_REV_LIST                       	= 20;
    WSM_INDEX_LIST                     	= 21;
    WSM_SIZE_LIST                      	= 22;
    WSM_VALUE_LIST                     	= 23;
    WSM_OBJECT_LIST                    	= 24;
    WSM_MCMOD_LIST                     	= 25;
    WSM_MCCOMP_LIST                    	= 26;
    WSM_ACMOD_LIST                     	= 27;
    WSM_ACVAR_LIST                     	= 28;

  { Mapping functions }
  function WsmMapStrToNode({IN} nodeString : LPSTR ) : HWSM_NODE; stdcall;
  function WsmMapOidToNode({IN} oid : smiLPOID) : HWSM_NODE ; stdcall;
  { Navigational functions }
  function WsmFindNodeChild({IN} hNode : HWSM_NODE) : HWSM_NODE; stdcall;
  function WsmFindNodeParent({IN} hNode : HWSM_NODE) : HWSM_NODE; stdcall;
  function WsmFindNodeNextSibling({IN} hNode : HWSM_NODE) : HWSM_NODE; stdcall;
  function WsmFindNodePrevSibling({IN} hNode : HWSM_NODE) : HWSM_NODE; stdcall;
  function WsmFindNextListElement({IN} hListElement : HWSM_LISTELEMENT) : HWSM_LISTELEMENT; stdcall;
  { Data retreival functions }
  function WsmGetNodeOid({IN} hNode : HWSM_NODE;
                         {IN}  infoID : smiINT;
                         {OUT} oid : smiLPOID) : SNMPAPI_STATUS; stdcall;
  function WsmGetNodeInt({IN} hNode : HWSM_NODE;
                         {IN} infoID : smiINT;
                         {OUT} lpInt : smiLPINT) : SNMPAPI_STATUS; stdcall;
  function WsmGetNodeString({IN} hNode : HWSM_NODE;
                            {IN} infoID : smiINT;
                            {IN} {OUT} lpStrlen : smiLPINT;
                            {OUT} pString : LPSTR) : SNMPAPI_STATUS ; stdcall;
  function WsmGetNodeList({IN} hNode : HWSM_NODE;
                          {IN} infoID : smiINT;
                          {OUT} lphListElement : LPHWSM_LISTELEMENT) : SNMPAPI_STATUS; stdcall;
  function WsmGetListElementOid({IN} hListElement : HWSM_LISTELEMENT;
                                {IN} infoID : smiINT;
                                {OUT} oid : smiLPOID) : SNMPAPI_STATUS; stdcall;
  function WsmGetListElementInt({IN} hListElement : HWSM_LISTELEMENT;
                                {IN} infoID : smiINT;
                                {OUT} lpInt : smiLPINT) : SNMPAPI_STATUS; stdcall;
  function WsmGetListElementString({IN} hListElement : HWSM_LISTELEMENT;
                                   {IN} infoID : smiINT;
                                   {IN} {OUT} lpStrlen : smiLPINT;
                                   {OUT} pString : LPSTR) : SNMPAPI_STATUS; stdcall;
  function WsmGetListElementList({IN} hListElement : HWSM_LISTELEMENT;
                                 {IN} infoID : smiINT;
                                 {OUT} lphListElement : LPHWSM_LISTELEMENT) : SNMPAPI_STATUS; stdcall;
  { Utility functions }
  function WsmGetLastError : SNMPAPI_STATUS;
  function WsmFreeList(hListElement : HWSM_LISTELEMENT) : SNMPAPI_STATUS;
  function WsmLoadModule(module : LPSTR) : SNMPAPI_STATUS;
  function WsmUnloadModule(module : LPSTR) : SNMPAPI_STATUS;

implementation

  const
    winmib_dll = 'winmib32.dll';

  { Mapping functions }
  function WsmMapStrToNode;               external winmib_dll name 'WsmMapStrToNode';
  function WsmMapOidToNode;               external winmib_dll name 'WsmMapOidToNode';
  { Navigational functions }
  function WsmFindNodeChild;              external winmib_dll name 'WsmFindNodeChild';
  function WsmFindNodeParent;             external winmib_dll name 'WsmFindNodeParent';
  function WsmFindNodeNextSibling;        external winmib_dll name 'WsmFindNodeNextSibling';
  function WsmFindNodePrevSibling;        external winmib_dll name 'WsmFindNodePrevSibling';
  function WsmFindNextListElement;        external winmib_dll name 'WsmFindNextListElement';
  { Data retreival functions }
  function WsmGetNodeOid;                 external winmib_dll name 'WsmGetNodeOid';
  function WsmGetNodeInt;                 external winmib_dll name 'WsmGetNodeInt';
  function WsmGetNodeString;              external winmib_dll name 'WsmGetNodeString';
  function WsmGetNodeList;                external winmib_dll name 'WsmGetNodeList';
  function WsmGetListElementOid;          external winmib_dll name 'WsmGetListElementOid';
  function WsmGetListElementInt;          external winmib_dll name 'WsmGetListElementInt';
  function WsmGetListElementString;       external winmib_dll name 'WsmGetListElementString';
  function WsmGetListElementList;         external winmib_dll name 'WsmGetListElementList';
  { Utility functions }
  function WsmGetLastError;               external winmib_dll name 'WsmGetLastError';
  function WsmFreeList;                   external winmib_dll name 'WsmFreeList';
  function WsmLoadModule;                 external winmib_dll name 'WsmLoadModule';
  function WsmUnloadModule;               external winmib_dll name 'WsmUnloadModule';
end.
