Unit jwlib;

(*-------------------------------------------------------------------------------------*)
(*                                                                                     *)
(*               Unit: JWLib                                                           *)
(*                                                                                     *)
(*               Copyright McCallum Whyman Associates Ltd 1996                         *)
(*                                                                                     *)
(*               Version 2.0                                                           *)
(*                                                                                     *)
(*               Author: Tony Whyman                                                   *)
(*                                                                                     *)
(*               Description: This module provides the registration calls for the      *)
(*                            J-Write component library.                               *)
(*-------------------------------------------------------------------------------------*)

interface

const jwlibname = 'J Write';

procedure Register;

implementation

uses jwctrls, jwdbctrl, fileview, mailedit, uuencode, textbuff, KeyEdit, 
     classes, DsgnIntf, bigmemo;

procedure Register;
begin
  RegisterComponents(jwlibname, [TFileViewer]);
  RegisterComponents(jwlibname, [TFileEditor]);
  RegisterComponents(jwlibname, [TMailEditor]);
  RegisterComponents(jwlibname, [TJWDBEdit]);
  RegisterComponents(jwlibname,[TUUEncoder,TUUDecoder]);
  RegisterComponents(jwlibname,[TTextStream,TEditStream]);
  RegisterComponents(jwlibname,[TProgressMeter]);
  RegisterComponents(jwlibname, [TBigMemo]);
  RegisterPropertyEditor(TypeInfo(TKeyDefinition),nil,'',TEditKeyEditor)

end;

End.
