unit Dbexmple;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, DBCtrls, StdCtrls, Mask, DB, DBTables, FileView,
  Jwdbctrl, ExtCtrls, DBLookup, Menus;

type
  TExampleForm = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Table1: TTable;
    DataSource1: TDataSource;
    label1: TLabel;
    DBNavigator1: TDBNavigator;
    STatusPanel: TPanel;
    CutBtn: TSpeedButton;
    CopyBtn: TSpeedButton;
    PasteBtn: TSpeedButton;
    WrapNoneBtn: TSpeedButton;
    WrapScreenBtn: TSpeedButton;
    WrapPrinterBtn: TSpeedButton;
    WrapAbsBtn: TSpeedButton;
    PrintBtn: TSpeedButton;
    FindBtn: TSpeedButton;
    FindDialog1: TFindDialog;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    JWDBEdit1: TJWDBEdit;
    Subject: TDBEdit;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    SaveAs1: TMenuItem;
    SaveSelection1: TMenuItem;
    N1: TMenuItem;
    SaveDialog1: TSaveDialog;
    SaveDialog2: TSaveDialog;
    Print1: TMenuItem;
    N2: TMenuItem;
    procedure CutBtnClick(Sender: TObject);
    procedure CopyBtnClick(Sender: TObject);
    procedure PasteBtnClick(Sender: TObject);
    procedure WrapNoneBtnClick(Sender: TObject);
    procedure WrapScreenBtnClick(Sender: TObject);
    procedure WrapPrinterBtnClick(Sender: TObject);
    procedure WrapAbsBtnClick(Sender: TObject);
    procedure PrintBtnClick(Sender: TObject);
    procedure jwdbEdit1StateChange(Sender: TObject);
    procedure FindBtnClick(Sender: TObject);
    procedure FindDialog1Find(Sender: TObject);
    procedure jwdbEdit1CaretMoved(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure JWDBEdit1EditCancel(Sender: TObject; var Confirmed: Boolean);
    procedure Exit1Click(Sender: TObject);
    procedure SaveAs1Click(Sender: TObject);
    procedure SaveSelection1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ExampleForm: TExampleForm;

implementation

{$R *.DFM}

procedure TExampleForm.CutBtnClick(Sender: TObject);
begin
     SendMessage(ActiveControl.Handle,wm_Cut,0,0)
end;

procedure TExampleForm.CopyBtnClick(Sender: TObject);
begin
     SendMessage(ActiveControl.Handle,wm_Copy,0,0)

end;

procedure TExampleForm.PasteBtnClick(Sender: TObject);
begin
     SendMessage(ActiveControl.Handle,wm_Paste,0,0)

end;

procedure TExampleForm.WrapNoneBtnClick(Sender: TObject);
begin
     jwdbEdit1.WrapMode := opNone

end;

procedure TExampleForm.WrapScreenBtnClick(Sender: TObject);
begin
     jwdbEdit1.WrapMode := opWrapScreenWidth

end;

procedure TExampleForm.WrapPrinterBtnClick(Sender: TObject);
begin
     jwdbEdit1.WrapMode := opPrinter
end;

procedure TExampleForm.WrapAbsBtnClick(Sender: TObject);
begin
     jwdbEdit1.WrapMode := opAbsoluteWrap

end;

procedure TExampleForm.PrintBtnClick(Sender: TObject);

begin
     jwdbEdit1.Print(Subject.Text,'J-Write Database Example',true,false,prAllPages,0,0)

end;

procedure TExampleForm.jwdbEdit1StateChange(Sender: TObject);
var NotEmpty: boolean;
    TextSelected: boolean;
    PasteAvailable: boolean;
begin
  With jwdbEdit1 Do
  Begin
     TextSelected := vsSelection in State;
     NotEmpty := not (vsEmpty in State);
     PasteAvailable := vsPasteAvailable in State;
     PrintBtn.Enabled := NotEmpty;
     FindBtn.Enabled := NotEmpty;
     CutBtn.Enabled := TextSelected;
     CopyBtn.Enabled := TextSelected;
     PasteBtn.Enabled := PasteAvailable
   End
end;

procedure TExampleForm.FindBtnClick(Sender: TObject);
begin
     If FindDialog1.Handle <> 0 Then
          SendMessage(FindDialog1.Handle,wm_Close,0,0);
     FindDialog1.FindText := jwdbEdit1.GetInitialFindStr;
     FindDialog1.Execute

end;

procedure TExampleForm.FindDialog1Find(Sender: TObject);
begin
     With Sender As TFindDialog Do
          If not jwdbEdit1.Find(TFindDialog(Sender),FindText,Options) Then
             MessageDlg('Text not found',mtError,[mbOK],0)

end;

procedure TExampleForm.jwdbEdit1CaretMoved(Sender: TObject);
begin
     With jwdbEdit1 Do
     If Not (vsEmpty in State) Then
     Begin
          If EstimatedLineNumber Then
             StatusPanel.Caption := Format('Ln ??? Ch %d Pg ??/??',[CharNumber])
          Else
              StatusPanel.Caption :=
                         Format('Ln %d Ch %d Pg %d/%d',
                                [EffectiveLineNumber+1,CharNumber,PageNumber,NumberOfPages])
     End
     Else
         StatusPanel.Caption := ''

end;

procedure TExampleForm.SpeedButton1Click(Sender: TObject);
begin
     With jwDBEdit1 Do
          ZoomFactor := ZoomFactor + 1     
end;

procedure TExampleForm.SpeedButton2Click(Sender: TObject);
begin
     With jwDBEdit1 Do
          ZoomFactor := ZoomFactor - 1
end;

procedure TExampleForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
     With JWDBEdit1.DataSource.Dataset Do
     If (State = dsEdit) Or (State = dsInsert) Then
        Post;
     Table1.Close

end;

procedure TExampleForm.FormCreate(Sender: TObject);
begin
     Table1.DatabaseName := ExtractFilePath(Application.Exename);
     Table1.Open
end;


procedure TExampleForm.JWDBEdit1EditCancel(Sender: TObject;
  var Confirmed: Boolean);
begin
    Confirmed := MessageDlg('Lose all Edits?',mtConfirmation,[mbOK,mbCancel],0)
                         = mrOK

end;

procedure TExampleForm.Exit1Click(Sender: TObject);
begin
     Close
end;

procedure TExampleForm.SaveAs1Click(Sender: TObject);
begin
     With SaveDialog1 Do
     If Execute Then
        JWDBEdit1.SaveAs(FileName)
end;

procedure TExampleForm.SaveSelection1Click(Sender: TObject);
begin
     With SaveDialog2 Do
     If Execute Then
        JWDBEdit1.SaveSelection(FileName)

end;

end.
