(******************************************************************************
*                                  StreamUt                                   *
*                                                                             *
* Stupid Stream Utils                                                         *
******************************************************************************)
unit StreamUt;

interface

uses
   classes
   ;

procedure WriteIntToStream(Stream : TStream; Value : integer);
function ReadIntFromStream(Stream : TStream) : integer;
procedure WriteStrToStream(Stream : TStream; Value : String);
function ReadStrFromStream(Stream : TStream) : String;
procedure WriteBoolToStream(Stream : TStream; Value : boolean);
function ReadBoolFromStream(Stream : TStream) : boolean;
procedure WriteDoubleToStream(Stream : TStream; Value : double);
function ReadDoubleFromStream(Stream : TStream) : double;

implementation

(******************************************************************************
*                              WriteIntToStream                               *
******************************************************************************)
procedure WriteIntToStream;
begin
   Stream.writeBuffer(Value, sizeof(Value));
end; { WriteIntToStream }

(******************************************************************************
*                              ReadIntFromStream                              *
******************************************************************************)
function ReadIntFromStream;
begin
   Stream.ReadBuffer(result, sizeof(Result));
end; { ReadIntFromStream }

(******************************************************************************
*                              WriteStrToStream                               *
******************************************************************************)
procedure WriteStrToStream;
begin
   WriteIntToStream(Stream, length(Value));
   Stream.writeBuffer(pchar(Value)^, length(Value));
end; { WriteStrToStream }

(******************************************************************************
*                              ReadStrFromStream                              *
******************************************************************************)
function ReadStrFromStream;
var
   theLength : integer;
begin
   theLength := ReadIntFromStream(Stream);
   setLength(result, theLength);
   Stream.readBuffer(pchar(result)^, theLength);
end; { ReadStrFromStream }

(******************************************************************************
*                              WriteBoolToStream                              *
******************************************************************************)
procedure WriteBoolToStream;
begin
   stream.writeBuffer(Value, sizeof(Value));
end; { WriteBoolToStream }

(******************************************************************************
*                             ReadBoolFromStream                              *
******************************************************************************)
function ReadBoolFromStream;
begin
   stream.readBuffer(Result, sizeof(Result));
end; { ReadBoolFromStream }

(******************************************************************************
*                             WriteDoubleToStream                             *
******************************************************************************)
procedure WriteDoubleToStream;
begin
   stream.WriteBuffer(value, sizeof(value));
end; { WriteDoubleToStream }

(******************************************************************************
*                            ReadDoubleFromStream                             *
******************************************************************************)
function ReadDoubleFromStream;
begin
   stream.readBuffer(Result, sizeof(Result));
end; { ReadDoubleFromStream }

(******************************************************************************
*                                    end.                                     *
******************************************************************************)
end.
