#include "sigaware.hpp"
#include <iostream.h>

class Manager : public SigAware 
{
   public:

 void writeCache() 
 { 
    cout << "Manager : writeCache()" << endl; 
 }

 virtual void sighandler(int iSig) 
 {
    switch(iSig)  
    {
       case SIGTERM : writeCache();
               break;
       case SIGINT  : writeCache();
               break;
    }
 }
}; 

class Scribe : public SigAware
{
   public:
 virtual void sighandler(int iSig)
 {
    cout << "Scribe : signal = " << iSig << endl;
 }
};
