// textprnt.h

/*******************************************************************************

						TTextPrinter
						------------

	The TTextPrinter class provide the user with easy aceess a printer to
	print plain text documents.

	This code does not rely on any specific C++ windowing library (like OWL
	or MFC). Only direct API calls are made.

	Author		:	Adi Degani
	Copyright	: 	Adi Degani  1996-7

*******************************************************************************/

#if !defined(TEXTPRNT_H)
#define TEXTPRNT_H

#if !defined(STRICT)
#	define STRICT
#endif

#include <windows.h>
#include <commdlg.h>
#include <stdio.h>


class TTextPrinter
	{
	public :
		TTextPrinter(DWORD cpi=MAKELONG(17,6), int tabWidth=8, COLORREF aColor=0);
		TTextPrinter(HDC dc, DWORD cpi=MAKELONG(17,6), int tabWidth=8, COLORREF aColor=0);
		virtual ~TTextPrinter();

		BOOL Setup(HWND hwndParent=NULL);
		BOOL SelectFont(HWND hwndParent=NULL);
		void SetCPI(DWORD cpi);
		void SetColor(COLORREF aColor)	{ color = aColor; }
		void SetLineWrapping(BOOL bSet)	{ bLineWrapping = bSet; }

		virtual void WriteString(const char* sz);
		void WriteChar(char ch);
		int _cdecl pprintf(const char* format, ...);

		BOOL Ok() const { return pd.hDC != NULL; }
		DWORD GetPageCharExt() const { return dwCharExtent; }

		operator BOOL() const { return Ok(); }

	protected :
		COLORREF color;
		BOOL bLineWrapping;

		virtual void PageHeader(int pageNo) {}

	private :
		PRINTDLG pd;
		LOGFONT lf;
		int row, column, page;
		BOOL isAlias;
		int iTabWidth;
		DWORD dwCPI;
		DWORD dwCharExtent;
		BOOL documentON;


		void InitDefaultPrinter();
		void ClosePrinter();
		void PrepareDC();
		void StartDocument();
		void EndDocument();
		void NextLine();
		void NextPage();
		HFONT SetFont();

		TTextPrinter(const TTextPrinter& tp) {}
		TTextPrinter& operator = (const TTextPrinter& tp) { return *this; }
	};



inline TTextPrinter& operator << (TTextPrinter& tp, char ch)
	{
	tp.WriteChar(ch);
	return tp;
	}

inline TTextPrinter& operator << (TTextPrinter& tp, const char* sz)
	{
	tp.WriteString(sz);
	return tp;
	}

inline TTextPrinter& operator << (TTextPrinter& tp, int i)
	{
	tp.pprintf("%d", i);
	return tp;
	}

inline TTextPrinter& operator << (TTextPrinter& tp, unsigned int ui)
	{
	tp.pprintf("%u", ui);
	return tp;
	}

inline TTextPrinter& operator << (TTextPrinter& tp, short s)
	{
	tp.pprintf("%d", s);
	return tp;
	}

inline TTextPrinter& operator << (TTextPrinter& tp, unsigned short us)
	{
	tp.pprintf("%u", us);
	return tp;
	}

inline TTextPrinter& operator << (TTextPrinter& tp, long l)
	{
	tp.pprintf("%ld", l);
	return tp;
	}

inline TTextPrinter& operator << (TTextPrinter& tp, unsigned long ul)
	{
	tp.pprintf("%lu", ul);
	return tp;
	}

inline TTextPrinter& operator << (TTextPrinter& tp, float f)
	{
	tp.pprintf("%f", f);
	return tp;
	}

inline TTextPrinter& operator << (TTextPrinter& tp, double d)
	{
	tp.pprintf("%lf", d);
	return tp;
	}

inline TTextPrinter& operator << (TTextPrinter& tp, long double ld)
	{
	tp.pprintf("%lf", ld);
	return tp;
	}



#endif // TEXTPRNT_H




