#include "sigaware.hpp"
#include "manager.hpp"
#include "scribe.hpp"
#include <iostream.h>

void main()
{
 Scribe aScribe;
 Manager aMgr;

 struct sigaction sigact;

 sigact.sa_handler=SigAware::sigRouter;
 sigemptyset(&sigact.sa_mask);
 sigact.sa_flags=0;

 if (sigaction(SIGINT,&sigact,NULL) < 0)
  cout << "could not install handler for SIGINT" << endl;
 if (sigaction(SIGTERM,&sigact,NULL) < 0)
  cout << "could not install handler for SIGTERM" << endl;
 if (sigaction(SIGUSR1,&sigact,NULL) < 0)
  cout << "could not install handler for SIGUSR1" << endl;

 while (1);
}

// SAMPLE TEST OUTPUT

(koblenz):/u/remy$ sigtest &
[1] 306
(koblenz):/u/remy$ kill -USR1 306

>>>>> Scribe : signal = 10

(koblenz):/u/remy$ kill -TERM 306

>>>>> Manager : writeCache()
>>>>> Scribe : signal = 15

(koblenz):/u/remy$ kill -HUP 306
(koblenz):/u/remy$ 

>>>>> [1]+  Hangup  sigtest  [i.e. the process was terminated] 

(koblenz):/u/remy$ 


