/*
   variables.c

   bf 11-28-96
*/

#include <string.h>
#include <exec/memory.h>
#include <proto/exec.h>

#include "script_library.h"
#include "variables.h"

#define varAllocMem(pool,size) AllocPooled(pool,size)
#define varFreeMem(pool,ptr,size) FreePooled(pool,ptr,size)

#if 0
/// varAllocMem()
static void *
varAllocMem (void *pool, ULONG size)
{
  if (pool)
    return AllocPooled (pool, size);
  else
    return AllocMem (size, MEMF_PUBLIC);
}
///

/// varFreeMem()
static void
varFreeMem (void *pool, void *ptr, ULONG size)
{
  if (pool)
    FreePooled (pool, ptr, size);
  else
    FreeMem (ptr, size);
}
///
#endif

/// FreeVariables()
void
FreeVariables (struct ScriptContext *sc)
{
  MinNode *node, *next;

  for (next = node = sc -> sc_Vars.mlh_Head; next = node -> mln_Succ; node = next)
    FreeVariable (sc, (ScriptVar *) node);
}
///

/// FreeVariable()
void
FreeVariable (struct ScriptContext *sc, ScriptVar *var)
{
  void *pool = NULL;

  Remove ((struct Node *) var);
  pool = sc -> sc_MemPool;

  if (var -> sv_Name)
    varFreeMem (pool, var -> sv_Name, strlen (var -> sv_Name) + 1);
  if (var -> sv_Type == VT_STRING)
  {
    varFreeMem (pool, var -> uv.uv_Value, strlen (var -> uv.uv_Value) + 1);
  }
  varFreeMem (pool, var, sizeof (ScriptVar));
}
///

/// SetStringVariable()
ScriptVar *
SetStringVariable (struct ScriptContext *sc, char *name, char *value)
{
  MinNode *node, *next;
  void *pool = NULL;
  ScriptVar *var;
  ULONG len;

  pool = sc -> sc_MemPool;

  for (next = node = sc -> sc_Vars.mlh_Head; next = node -> mln_Succ; node = next)
    if (strcmp (((ScriptVar *) node) -> sv_Name, name) == 0
      && ((ScriptVar *) node) -> sv_Type == VT_STRING)
    {
      var = (ScriptVar *) node;

      varFreeMem (pool, var -> uv.uv_Value, strlen (var -> uv.uv_Value) + 1);

      len = strlen (value) + 1;
      if (!(var -> uv.uv_Value = varAllocMem (pool, len)))
        return NULL;
      CopyMem (value, var -> uv.uv_Value, len);

      return var;
    }

  if (!(var = varAllocMem (pool, sizeof (ScriptVar))))
    return NULL;

  len = strlen (name) + 1;
  if (!(var -> sv_Name = varAllocMem (pool, len)))
    goto cleanup;
  CopyMem (name, var -> sv_Name, len);

  len = strlen (value) + 1;
  if (!(var -> uv.uv_Value = varAllocMem (pool, len)))
    goto cleanup;
  CopyMem (value, var -> uv.uv_Value, len);

  var -> sv_Type = VT_STRING;
  AddHead ((struct List *) &sc -> sc_Vars, (struct Node *) var);
  return var;

cleanup:

  if (var)
  {
    if (var -> sv_Name)
      varFreeMem (pool, var -> sv_Name, strlen (var -> sv_Name) + 1);
    varFreeMem (pool, var, sizeof (ScriptVar));
  }
  return NULL;
}
///

/// GetStringVariable()
char *
GetStringVariable (struct ScriptContext *sc, char *name)
{
  MinNode *node, *next;

  for (next = node = sc -> sc_Vars.mlh_Head; next = node -> mln_Succ; node = next)
    if (strcmp (((ScriptVar *) node) -> sv_Name, name) == 0
      && ((ScriptVar *) node) -> sv_Type == VT_STRING)
      return ((ScriptVar *) node) -> uv.uv_Value;

  return NULL;
}
///
