#include "arryst.hpp"
#include <math.h>
#include <afxwin.h>

const double DELTA=1.000000e-003;
UINT TESTFLAGS=0;
inline BOOL SAME( double x, double y ) { return(fabs(x-y)<DELTA); }
inline BOOL SAME( const CString x, const CString y ) { return(x==y); }
void TEST( BOOL condition, TCHAR *message);
void ASKVERIFY( const CString &message );

FILE  *outfile;
INT ntest;
INT ncheck;
INT nfail;
CString current_test=_T("12345NONE");
UINT test_number;

void TEST( BOOL condition, TCHAR *message)
{
    ncheck++;
    if (!condition) {
        nfail++;
        _ftprintf( outfile, _T("Test %d (%s), FAIL: %s\n"),test_number,current_test,message ); 
    }
}


void Test1();
void Test2();
void Test3();
void Test4();
void Test5();
void Test6();
void Test7();

extern "C" int _tmain(int argc, TCHAR **argv);

int _tmain(int argc, TCHAR **argv)
{
	AfxWinInit(GetModuleHandle(NULL), NULL, NULL, 0);
	if (argc>1)
		TESTFLAGS=_ttoi(argv[1]);
	outfile = stdout;
	ntest = 7;
	ncheck = 0;
	nfail = 0;
	_ftprintf( outfile, _T("ARRYST.CPP - class ArrayStatistics\n"));
	Test1();
	Test2();
	Test3();
	Test4();
	Test5();
	Test6();
	Test7();
	_ftprintf( outfile, _T("%d Tests\t %d Checks\t %d Failures \n"),ntest,ncheck,nfail);
	return(1);
}


void Test1()
{
    test_number=1;
    current_test=_T("positive_array");
    const int narray=5;
    double array[narray];
    int sign=1;
    array[0] = sign*1.0;
    array[1] = sign*2.0;
    array[2] = sign*3.0;
    array[3] = sign*4.0;
    array[4] = sign*5.0;
    ArrayStatistics stats(array,narray);
    TEST( SAME( stats.Status(), ARRSTAT_NO_PROBLEM) , _T("stats.Status() == ARRSTAT_NO_PROBLEM") );
    TEST( SAME( stats.Minimum(), sign*1.0) , _T("stats.Minimum() == sign*1.0") );
    TEST( SAME( stats.Maximum(), sign*5.0) , _T("stats.Maximum() == sign*5.0") );
    TEST( SAME( stats.MinOccurredAt(), 0) , _T("stats.MinOccurredAt() == 0") );
    TEST( SAME( stats.MaxOccurredAt(), 4) , _T("stats.MaxOccurredAt() == 4") );
    TEST( SAME( stats.Mean(), sign*3.0) , _T("stats.Mean() == sign*3.0") );
}

void Test2()
{
    test_number=2;
    current_test=_T("negative_array");
    const int narray=5;
    double array[narray];
    int sign= -1;
    array[0] = sign*1.0;
    array[1] = sign*2.0;
    array[2] = sign*3.0;
    array[3] = sign*4.0;
    array[4] = sign*5.0;
    ArrayStatistics stats(array,narray);
    TEST( SAME( stats.Status(), ARRSTAT_NO_PROBLEM) , _T("stats.Status() == ARRSTAT_NO_PROBLEM") );
    TEST( SAME( stats.Minimum(), sign*5.0) , _T("stats.Minimum() == sign*5.0") );
    TEST( SAME( stats.Maximum(), sign*1.0) , _T("stats.Maximum() == sign*1.0") );
    TEST( SAME( stats.MinOccurredAt(), 4) , _T("stats.MinOccurredAt() == 4") );
    TEST( SAME( stats.MaxOccurredAt(), 0) , _T("stats.MaxOccurredAt() == 0") );
    TEST( SAME( stats.Mean(), sign*3.0) , _T("stats.Mean() == sign*3.0") );
}

void Test3()
{
    test_number=3;
    current_test=_T("bad_count");
    double value=10.0;
    int count= -1;
    ArrayStatistics stats(&value,count);
    TEST( SAME( stats.Status(), ARRSTAT_INVALID_COUNT) , _T("stats.Status() == ARRSTAT_INVALID_COUNT") );
}

void Test4()
{
    test_number=4;
    current_test=_T("bad_count2");
    double value=10.0;
    int count= 0;
    ArrayStatistics stats(&value,count);
    TEST( SAME( stats.Status(), ARRSTAT_INVALID_COUNT) , _T("stats.Status() == ARRSTAT_INVALID_COUNT") );
}

void Test5()
{
    test_number=5;
    current_test=_T("count_is_1");
    double value=10.0;
    int count= 1;
    ArrayStatistics stats(&value,count);
    TEST( SAME( stats.Status(), ARRSTAT_NO_PROBLEM) , _T("stats.Status() == ARRSTAT_NO_PROBLEM") );
    TEST( SAME( stats.Minimum(), value) , _T("stats.Minimum() == value") );
    TEST( SAME( stats.Maximum(), value) , _T("stats.Maximum() == value") );
    TEST( SAME( stats.Mean(), value) , _T("stats.Mean() == value") );
    TEST( SAME( stats.MinOccurredAt(), 0) , _T("stats.MinOccurredAt() == 0") );
    TEST( SAME( stats.MaxOccurredAt(), 0) , _T("stats.MaxOccurredAt() == 0") );
}

void Test6()
{
    test_number=6;
    current_test=_T("count_is_1b");
    double value= -10.0;
    int count= 1;
    ArrayStatistics stats(&value,count);
    TEST( SAME( stats.Status(), ARRSTAT_NO_PROBLEM) , _T("stats.Status() == ARRSTAT_NO_PROBLEM") );
    TEST( SAME( stats.Minimum(), value) , _T("stats.Minimum() == value") );
    TEST( SAME( stats.Maximum(), value) , _T("stats.Maximum() == value") );
    TEST( SAME( stats.Mean(), value) , _T("stats.Mean() == value") );
    TEST( SAME( stats.MinOccurredAt(), 0) , _T("stats.MinOccurredAt() == 0") );
    TEST( SAME( stats.MaxOccurredAt(), 0) , _T("stats.MaxOccurredAt() == 0") );
}

void Test7()
{
    test_number=7;
    current_test=_T("");
    const int narray=10;
    double array[narray];
    int sign=1;
    char str[10]; strcpy(str,"Hello");
    array[0] = 10.0;
    array[1] = -23.0;
    array[2] = 13.0;
    array[3] = -42.0;
    array[4] = 5.0;
    array[5] = -11.0;
    array[6] = 22.0;
    array[7] = -13.0;
    array[8] = 64.0;
    array[9] = -75.0;
    ArrayStatistics stats(array,narray);
    TEST( SAME( stats.Status(), ARRSTAT_NO_PROBLEM) , _T("stats.Status() == ARRSTAT_NO_PROBLEM") );
    TEST( SAME( stats.Minimum(), -75) , _T("stats.Minimum() == -75") );
    TEST( SAME( stats.Maximum(), 64) , _T("stats.Maximum() == 64") );
    TEST( SAME( stats.MinOccurredAt(), 9) , _T("stats.MinOccurredAt() == 9") );
    TEST( SAME( stats.MaxOccurredAt(), 8) , _T("stats.MaxOccurredAt() == 8") );
    TEST( SAME( stats.Mean(), -5) , _T("stats.Mean() == -5") );
    TEST( SAME(str,_T("Hello")) , _T("str == Hello") );
}
