/*>>> x_eat.c: the eater selector subsystem */

/* Revised: 1993.05.15 */

#include <stdio.h>
#include <stdlib.h>

#include "sandef.h"
#include "sanvar.h"

#include "sanatk.h"
#include "sanmer.h"
#include "sanmsc.h"
#include "sansrt.h"

#include "x_eat.h"

/*--> EATInit: one time call to initialize the EAT subsystem */
nonstatic
void
EATInit(void)
{

return;
}

/*--> EATTerm: one time call to terminate the EAT subsystem */
nonstatic
void
EATTerm(void)
{

return;
}

/*--> EATNewGame: send "new game" request to the EAT subsystem */
nonstatic
void
EATNewGame(void)
{

return;
}

/*--> EATSelect: select a move */
nonstatic
void
EATSelect(void)
{
siT done;
mptrT mptr;
cpevT eval;
siT i;

/* set default */

done = 0;

/* check if only one move */

if (!done)
	if ((mptr = SANSingleMove()) != NULL)
		{
		select_m = *mptr;
		done = 1;
		};

/* look for a mating move */

if (!done)
	if ((mptr = SANMatingMove()) != NULL)
		{
		select_m = *mptr;
		done = 1;
		};

/* choose biggest capture */

if (!done)
	{
	curr_g.g_curr = curr_g.g_base;
	for (i = 0; i < curr_g.g_gmvc; i++)
		{
		SANExecute();
		eval = cpmv[curr_e.e_actc] - cpmv[curr_e.e_pasc];
		SANRetract();
		curr_g.g_curr->m_eval = -eval;
		curr_g.g_curr++;
		};
	SANSortEval();
	if (curr_g.g_base->m_eval >
		(cpmv[curr_e.e_actc] - cpmv[curr_e.e_pasc]))
		{
		select_m = *curr_g.g_base;
		done = 1;
		};
	};

/* pick at random  */

if (!done)
	{
	select_m = *(curr_g.g_base + (rand() % curr_g.g_gmvc));
	done = 1;
	};

return;
}

/*--> EATPlay: send "play move" request to the EAT subsystem */
nonstatic
void
EATPlay(void)
{

return;
}

/*--> EATUnplay: send "unplay move" request to the EAT subsystem */
nonstatic
void
EATUnplay(void)
{

return;
}

/*--> EATSetPos: send "set position" request to the EAT subsystem */
nonstatic
void
EATSetPos(void)
{

return;
}

/*--> EATConfig: send "re-configuration" request to the EAT subsystem */
nonstatic
void
EATConfig(void)
{

return;
}

/* x_eat.c: EOF */
