/*>>> sanint.c: SAN project initialization */

/* Revised: 1994.01.24 */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "sandef.h"
#include "sanvar.h"

#include "sancmd.h"
#include "sanepd.h"
#include "sangtc.h"
#include "sanhsh.h"
#include "sanhst.h"
#include "sanint.h"
#include "sanmnd.h"
#include "sanmsc.h"
#include "sanopt.h"
#include "sanpos.h"
#include "sansss.h"
#include "santag.h"
#include "sanutl.h"
#include "sanval.h"

/*--> SANInitPosition: set up starting board position */
static
void
SANInitPosition(void)
{
sqT sq;
fileT file;

/* clear the setup flag */

setup = 0;

/* set the game termination code */

SANGTCSet(gtc_norm);

/* clear the playing board */

for (sq = sq_a1; sq <= sq_h8; sq++)
	gb.bv[sq] = cp_v0;

/* set the ground environment values */

curr_e.e_actc = c_w;
curr_e.e_pasc = c_b;
curr_e.e_cast = cast_wk | cast_wq | cast_bk | cast_bq;
curr_e.e_epsq = sq_nil;
curr_e.e_hmvc = 0;
curr_e.e_fmvn = 1;

/* set up the first/last rank pieces */

gb.bv[sq_a1] = gb.bv[sq_h1] = cp_wr;
gb.bv[sq_b1] = gb.bv[sq_g1] = cp_wn;
gb.bv[sq_c1] = gb.bv[sq_f1] = cp_wb;
gb.bv[sq_d1] = cp_wq;
gb.bv[sq_e1] = cp_wk;

gb.bv[sq_a8] = gb.bv[sq_h8] = cp_br;
gb.bv[sq_b8] = gb.bv[sq_g8] = cp_bn;
gb.bv[sq_c8] = gb.bv[sq_f8] = cp_bb;
gb.bv[sq_d8] = cp_bq;
gb.bv[sq_e8] = cp_bk;

/* set up the pawns */

for (file = file_a; file <= file_h; file++)
	{
	gb.bm[rank_2][file] = cp_wp;
	gb.bm[rank_7][file] = cp_bp;
	};

return;
}

/*--> SANInitGround: ground state initialize/reset */
nonstatic
void
SANInitGround(void)
{
/* internal */

SANInitPosition();
SANHistClear();
SANUpdate();

/* strategies */

SANSSS(sep_newgame);

return;
}

/*--> SANInit: one time call initialization */
nonstatic
void
SANInit(void)
{
rankT rank;
fileT file;
sqT sq;
xsqT xsq;

/* set the program running */

progdone = 0;

/* seed the psuedorandom generator */

srand(time(NULL));

/* initialize the nil string */

nilstr = "nil";

/* initialize ASCII char vectors; slight English bias in the first two */

accv[c_w] = 'w';   accv[c_b] = 'b';   accv[c_v] = ' ';   accv[c_x] = '*';

acpv[p_p] = 'P';   acpv[p_n] = 'N';   acpv[p_b] = 'B';   acpv[p_r] = 'R';
acpv[p_q] = 'Q';   acpv[p_k] = 'K';   acpv[p_v] = ' ';   acpv[p_x] = '*';

/* the next two appear to be universally accepted */

for (rank = rank_1; rank <= rank_8; rank++)
	acrv[rank] = '1' + rank;

for (file = file_a; file <= file_h; file++)
	acfv[file] = 'a' + file;

/* initialize the conversion vectors */

cv_c_cpv[cp_wp] = cv_c_cpv[cp_wn] = cv_c_cpv[cp_wb] = c_w;
cv_c_cpv[cp_wr] = cv_c_cpv[cp_wq] = cv_c_cpv[cp_wk] = c_w;

cv_c_cpv[cp_bp] = cv_c_cpv[cp_bn] = cv_c_cpv[cp_bb] = c_b;
cv_c_cpv[cp_br] = cv_c_cpv[cp_bq] = cv_c_cpv[cp_bk] = c_b;

cv_c_cpv[cp_v0] = c_v;
cv_c_cpv[cp_x0] = cv_c_cpv[cp_x1] = cv_c_cpv[cp_x2] = c_x;

cv_p_cpv[cp_wp] = cv_p_cpv[cp_bp] = p_p;
cv_p_cpv[cp_wn] = cv_p_cpv[cp_bn] = p_n;
cv_p_cpv[cp_wb] = cv_p_cpv[cp_bb] = p_b;
cv_p_cpv[cp_wr] = cv_p_cpv[cp_br] = p_r;
cv_p_cpv[cp_wq] = cv_p_cpv[cp_bq] = p_q;
cv_p_cpv[cp_wk] = cv_p_cpv[cp_bk] = p_k;

cv_p_cpv[cp_v0] = p_v;
cv_p_cpv[cp_x0] = cv_p_cpv[cp_x1] = cv_p_cpv[cp_x2] = p_x;

cv_cp_cpv[c_w][p_p] = cp_wp;
cv_cp_cpv[c_w][p_n] = cp_wn;
cv_cp_cpv[c_w][p_b] = cp_wb;
cv_cp_cpv[c_w][p_r] = cp_wr;
cv_cp_cpv[c_w][p_q] = cp_wq;
cv_cp_cpv[c_w][p_k] = cp_wk;

cv_cp_cpv[c_b][p_p] = cp_bp;
cv_cp_cpv[c_b][p_n] = cp_bn;
cv_cp_cpv[c_b][p_b] = cp_bb;
cv_cp_cpv[c_b][p_r] = cp_br;
cv_cp_cpv[c_b][p_q] = cp_bq;
cv_cp_cpv[c_b][p_k] = cp_bk;

/* initialize the special case promotion piece vector */

cv_p_scmvv[scmv_reg] = p_x;   cv_p_scmvv[scmv_epc] = p_x;
cv_p_scmvv[scmv_cks] = p_x;   cv_p_scmvv[scmv_cqs] = p_x;
cv_p_scmvv[scmv_ppn] = p_n;   cv_p_scmvv[scmv_ppb] = p_b;
cv_p_scmvv[scmv_ppr] = p_r;   cv_p_scmvv[scmv_ppq] = p_q;

/* initialize the color inversion vector */

inv_cv[c_w] = c_b;   inv_cv[c_b] = c_w;

/* initialize the game termination conversion vector */

cv_gtc_gsv[gs_norm] = gtc_norm;
cv_gtc_gsv[gs_bust] = gtc_norm;
cv_gtc_gsv[gs_wcmt] = gtc_wwin;
cv_gtc_gsv[gs_bcmt] = gtc_bwin;
cv_gtc_gsv[gs_wsmt] = gtc_draw;
cv_gtc_gsv[gs_bsmt] = gtc_draw;
cv_gtc_gsv[gs_dhmc] = gtc_draw;
cv_gtc_gsv[gs_dmat] = gtc_draw;
cv_gtc_gsv[gs_drep] = gtc_draw;
cv_gtc_gsv[gs_dagr] = gtc_draw;
cv_gtc_gsv[gs_wres] = gtc_bwin;
cv_gtc_gsv[gs_bres] = gtc_wwin;
cv_gtc_gsv[gs_over] = gtc_draw;

/* initialize the game termination string vector */

gtcstrv[gtc_wwin] = "1-0";
gtcstrv[gtc_bwin] = "0-1";
gtcstrv[gtc_draw] = "1/2-1/2";
gtcstrv[gtc_norm] = "*";

/* initialize the game termination input marker string vector */

gtimstrv[gtim_norm] = "*";
gtimstrv[gtim_drw0] = "1/2-1/2";
gtimstrv[gtim_drw1] = "1/2";
gtimstrv[gtim_drw2] = "draw";
gtimstrv[gtim_drw3] = "drawn";
gtimstrv[gtim_wwn0] = "1-0";
gtimstrv[gtim_wwn1] = "1/0";
gtimstrv[gtim_wwn2] = "1:0";
gtimstrv[gtim_bwn0] = "0-1";
gtimstrv[gtim_bwn1] = "0/1";
gtimstrv[gtim_bwn2] = "0:1";
gtimstrv[gtim_res0] = "resign";
gtimstrv[gtim_res1] = "resigns";

/* initialize the game termination input marker conversion vector */

cv_gtc_gtimv[gtim_norm] = gtc_norm;
cv_gtc_gtimv[gtim_drw0] = gtc_draw;
cv_gtc_gtimv[gtim_drw1] = gtc_draw;
cv_gtc_gtimv[gtim_drw2] = gtc_draw;
cv_gtc_gtimv[gtim_drw3] = gtc_draw;
cv_gtc_gtimv[gtim_wwn0] = gtc_wwin;
cv_gtc_gtimv[gtim_wwn1] = gtc_wwin;
cv_gtc_gtimv[gtim_wwn2] = gtc_wwin;
cv_gtc_gtimv[gtim_bwn0] = gtc_bwin;
cv_gtc_gtimv[gtim_bwn1] = gtc_bwin;
cv_gtc_gtimv[gtim_bwn2] = gtc_bwin;
cv_gtc_gtimv[gtim_res0] = gtc_nil;
cv_gtc_gtimv[gtim_res1] = gtc_nil;

/* initialize directional vectors */

dvv[dx_0] = dv_0;   dvv[dx_1] = dv_1;
dvv[dx_2] = dv_2;   dvv[dx_3] = dv_3;
dvv[dx_4] = dv_4;   dvv[dx_5] = dv_5;
dvv[dx_6] = dv_6;   dvv[dx_7] = dv_7;
dvv[dx_8] = dv_8;   dvv[dx_9] = dv_9;
dvv[dx_a] = dv_a;   dvv[dx_b] = dv_b;
dvv[dx_c] = dv_c;   dvv[dx_d] = dv_d;
dvv[dx_e] = dv_e;   dvv[dx_f] = dv_f;

xdvv[dx_0] = xdv_0;   xdvv[dx_1] = xdv_1;
xdvv[dx_2] = xdv_2;   xdvv[dx_3] = xdv_3;
xdvv[dx_4] = xdv_4;   xdvv[dx_5] = xdv_5;
xdvv[dx_6] = xdv_6;   xdvv[dx_7] = xdv_7;
xdvv[dx_8] = xdv_8;   xdvv[dx_9] = xdv_9;
xdvv[dx_a] = xdv_a;   xdvv[dx_b] = xdv_b;
xdvv[dx_c] = xdv_c;   xdvv[dx_d] = xdv_d;
xdvv[dx_e] = xdv_e;   xdvv[dx_f] = xdv_f;

/* initialize the extended board */

for (xsq = 0; xsq < xsqL; xsq++)
	gxb.xbv[xsq] = cp_x0;

for (sq = sq_a1; sq <= sq_h8; sq++)
	gxb.xbv[map_xsq_sq(sq)] = cp_v0;

/* initialize the piece values */

valcpv[cp_wp] = valcpv[cp_bp] = valpv[p_p] = val_p;
valcpv[cp_wn] = valcpv[cp_bn] = valpv[p_n] = val_n;
valcpv[cp_wb] = valcpv[cp_bb] = valpv[p_b] = val_b;
valcpv[cp_wr] = valcpv[cp_br] = valpv[p_r] = val_r;
valcpv[cp_wq] = valcpv[cp_bq] = valpv[p_q] = val_q;
valcpv[cp_wk] = valcpv[cp_bk] = valpv[p_k] = val_k;
valcpv[cp_v0] = valpv[p_v] = val_v;
valcpv[cp_x0] = valpv[p_x] = val_x;

/* initialize the null move */

null_m.m_flag = mf_null;
null_m.m_frcp = null_m.m_tocp = cp_nil;
null_m.m_frsq = null_m.m_tosq = sq_nil;
null_m.m_scmv = scmv_nil;
null_m.m_eval = ev_bust;

/* clear the dribble ouput file indicator */

do_fptr = NULL;

/* allocate tree leg storage */

Tree = (mptrT) SANMemGrab(sizeof(mT) * legL);

/* initialize the tag environment system */

SANTagInit();

/* initialize the EPD system */

SANEPDInit();

/* initialize the program option system */

SANOPTInit();

/* initialize the command processing system */

SANCMDInit();

/* initialize the hash code subsystem */

SANHashInit();

/* initialize the history subsystem */

SANHistInit();

/* initialize the search strategy subsystem */

SANSSSInit();

/* initialize the positional evaluation subsystem */

SANPosInit();

/* reset the analysis stack entry count (current ply) */

an = 0;

/* set the playing level (default to maximum) */

level = aL - 1;

/* set the average response time */

artsec = 10;

/* initialize the environment ground state */

SANInitGround();

/* ensure general configuration is trasnmitted */

SANSSS(sep_config);

return;
}

/*<<< sanint.c: EOF */
