/*>>> x_gtp.c: the GTP (Gillogly TECH program reincarnation) */

/* Revised: 1993.04.25 */

#include <stdio.h>
#include <stdlib.h>

#include "sandef.h"
#include "sanvar.h"

#include "sanmer.h"
#include "sanmsc.h"
#include "sansrt.h"

#include "x_gtp.h"

/*--> GTPInit: one time call to initialize the GTP subsystem */
nonstatic
void
GTPInit(void)
{

return;
}

/*--> GTPTerm: one time call to terminate the GTP subsystem */
nonstatic
void
GTPTerm(void)
{

return;
}

/*--> GTPNewGame: send "new game" request to the GTP subsystem */
nonstatic
void
GTPNewGame(void)
{

return;
}

/*--> GTPSelectMove: select a move */
nonstatic
void
GTPSelect(void)
{
siT done;
mptrT mptr;
cpevT eval;
siT i;

/* set default */

done = 0;

/* check if only one move */

if (!done)
	if ((mptr = SANSingleMove()) != NULL)
		{
		select_m = *mptr;
		done = 1;
		};

/* look for a mating move */

if (!done)
	if ((mptr = SANMatingMove()) != NULL)
		{
		select_m = *mptr;
		done = 1;
		};

/* choose biggest capture */

if (!done)
	{
	curr_g.g_curr = curr_g.g_base;
	for (i = 0; i < curr_g.g_gmvc; i++)
		{
		SANExecute();
		eval = cpmv[curr_e.e_actc] - cpmv[curr_e.e_pasc];
		SANRetract();
		curr_g.g_curr->m_eval = -eval;
		curr_g.g_curr++;
		};
	SANSortEval();
	if (curr_g.g_base->m_eval >
		(cpmv[curr_e.e_actc] - cpmv[curr_e.e_pasc]))
		{
		select_m = *curr_g.g_base;
		done = 1;
		};
	};

/* pick at random  */

if (!done)
	{
	select_m = *(curr_g.g_base + (rand() % curr_g.g_gmvc));
	done = 1;
	};

return;
}

/*--> GTPPlay: send "play move" request to the GTP subsystem */
nonstatic
void
GTPPlay(void)
{

return;
}

/*--> GTPUnplay: send "unplay move" request to the GTP subsystem */
nonstatic
void
GTPUnplay(void)
{

return;
}

/*--> GTPSetPos: send "set position" request to the GTP subsystem */
nonstatic
void
GTPSetPos(void)
{

return;
}

/*--> GTPConfig: send "re-configuration" request to the GTP subsystem */
nonstatic
void
GTPConfig(void)
{

return;
}

/* x_gtp.c: EOF */
