/*>>> santrm.c: SAN project terminations */

/* Revised: 1994.01.24 */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "sandef.h"
#include "sanvar.h"

#include "sancmd.h"
#include "sanepd.h"
#include "sanhsh.h"
#include "sanhst.h"
#include "sanpos.h"
#include "sansss.h"
#include "santag.h"
#include "santrm.h"
#include "sanutl.h"

/*--> SANTerm: one time call termination */
nonstatic
void
SANTerm(void)
{
/* terminate the positional evaluation subsystem */

SANPosTerm();

/* terminate the search strategy subsystem */

SANSSSTerm();

/* terminate the history subsystem */

SANHistTerm();

/* terminate the hash code subsystem */

SANHashTerm();

/* terminate the command processing subsystem */

SANCMDTerm();

/* terminate the EPD subsystem */

SANEPDTerm();

/* terminate the tag environment subsystem */

SANTagTerm();

/* release the tree leg storage */

SANMemFree(Tree);

/* close the dribble output file if needed */

if (do_fptr != NULL)
	{
	SANTextFileClose(do_fptr);
	do_fptr = NULL;
	};

return;
}

/*<<< santrm.c: EOF */
