/*>>> sanslm.c: SAN project string list management */

/* Revised: 1993.05.16 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "sandef.h"
#include "sanvar.h"

#include "sanslm.h"
#include "sanutl.h"

/*--> SANSLMMember: return string's member position, if any */
nonstatic
sleptrT
SANSLMMember(slaptrT slaptr, charptrT s)
{
sleptrT sleptr0, sleptr1;

sleptr0 = slaptr->sla_head;
sleptr1 = NULL;

while ((sleptr0 != NULL) && (sleptr1 == NULL))
	if (strcmp(sleptr0->sle_s, s) == 0)
		sleptr1 = sleptr0;
	else
		sleptr0 = sleptr0->sle_next;

return (sleptr1);
}

/*--> SANSLMAppend: append a string to the end of a list */
nonstatic
void
SANSLMAppend(slaptrT slaptr, charptrT s)
{
sleptrT sleptr;

sleptr = (sleptrT) SANMemGrab(sizeof(sleT));
sleptr->sle_s = SANStrGrab(s);
sleptr->sle_prev = slaptr->sla_tail;
sleptr->sle_next = NULL;

if (slaptr->sla_tail != NULL)
	slaptr->sla_tail->sle_next = sleptr;
else
	slaptr->sla_head = sleptr;
slaptr->sla_tail = sleptr;

return;
}

/*--> SANSLMReleaseElement: release storage for a string list element */
nonstatic
void
SANSLMReleaseElement(slaptrT slaptr, sleptrT sleptr)
{
if (sleptr->sle_prev == NULL)
	slaptr->sla_head = sleptr->sle_next;
else
	sleptr->sle_prev->sle_next = sleptr->sle_next;

if (sleptr->sle_next == NULL)
	slaptr->sla_tail = sleptr->sle_prev;
else
	sleptr->sle_next->sle_prev = sleptr->sle_prev;

SANMemFree(sleptr->sle_s);
SANMemFree(sleptr);

return;
}

/*--> SANSLMInitAnchor: initialize a string list anchor */
nonstatic
void
SANSLMInitAnchor(slaptrT slaptr)
{
slaptr->sla_head = slaptr->sla_tail = NULL;

return;
}

/*--> SANSLMReleaseAnchor: release storage for a string list anchor */
nonstatic
void
SANSLMReleaseAnchor(slaptrT slaptr)
{
sleptrT sleptr;

while ((sleptr = slaptr->sla_head) != NULL)
	SANSLMReleaseElement(slaptr, sleptr);
	

return;
}

/*<<< sanslm.c: EOF */
