/*>>> sanhst.c: SAN project playing history stack operations */

/* Revised: 1994.02.10 */

#include <stdio.h>
#include <time.h>

#include "sandef.h"
#include "sanvar.h"

#include "sanhst.h"
#include "sanmsc.h"
#include "sanutl.h"
#include "sanval.h"

/*--> SANHistPush: push a history record on the history stack */
nonstatic
void
SANHistPush(siT ordinal)
{
sqT sq;

if (hn == hL)
	SANFatal("SANHistPush: overflow");
else
	{
	hcurr->h_o = ordinal;
	hcurr->h_e = curr_e;
	hcurr->h_m = *curr_g.g_curr;
	for (sq = sq_a1; sq <= sq_h8; sq++)
		if ((sq % 2) == 0)
			hcurr->h_z[sq / 2] = gb.bv[sq];
		else
			hcurr->h_z[sq / 2] |= (gb.bv[sq] << 4);
	hcurr++;
	hn++;
	};

return;
}

/*--> SANHistPop: pop a history record off the history stack */
nonstatic
void
SANHistPop(void)
{
sqT sq;

if (hn == 0)
	SANFatal("SANHistPop: underflow");
else
	{
	/* drop history pointer and count */

	hcurr--;
	hn--;

	/* restore previous environment */

	curr_e = hcurr->h_e;

	/* restore previous board */

	for (sq = sq_a1; sq <= sq_h8; sq++)
		if ((sq % 2) == 0)
			gb.bv[sq] = hcurr->h_z[sq / 2] & 0x0f;
		else
			gb.bv[sq] = (hcurr->h_z[sq / 2] >> 4) & 0x0f;

	/* update to set generation */

	SANUpdate();

	/* indicate the move played from this postition */

	curr_g.g_curr = SANFindMove(&hcurr->h_m);
	};

return;
}

/*--> SANHistClear: clear/resethistory information */
nonstatic
void
SANHistClear(void)
{
hn = 0;
hcurr = hbase;

return;
}

/*--> SANHistInit: one time call to initialize history */
nonstatic
void
SANHistInit(void)
{
hbase = (hptrT) SANMemGrab(sizeof(hT) * hL);
SANHistClear();

return;
}

/*--> SANHistTerm: one time call to terminate history */
nonstatic
void
SANHistTerm(void)
{
SANMemFree(hbase);
hbase = hcurr = NULL;
hn = 0;

return;
}

/*<<< sanhst.c: EOF */
