/*>>> sansss.c: SAN project search strategy subsystem */

/* Revised: 1993.04.24 */

#include <stdio.h>
#include <stdlib.h>

#include "sandef.h"
#include "sanvar.h"

#include "sansss.h"

#include "x_eat.h"
#include "x_gtp.h"
#include "x_ran.h"
#include "x_sc0.h"
#include "x_sc1.h"

/**** Locals */

/* dispatch */

static frvptrT ssdv[ssL][sepL];

/*--> SANSSS: issue indicated call to all strategy modules */
nonstatic
void
SANSSS(sepT sep)
{
ssT ss;

for (ss = 0; ss < ssL; ss++)
	(ssdv[ss][sep])();

return;
}

/*--> SANSSSSelect: activate appropriate move selection */
nonstatic
void
SANSSSSelect(void)
{
(ssdv[ssv[curr_e.e_actc]][sep_select])();

return;
}

/*--> SANSSSInit: one time search strategy subsystem initialization */
nonstatic
void
SANSSSInit(void)
{
/* initilaize the strategy name vectors */

ssstrv[ss_eat] = "eat";
ssstrv[ss_gtp] = "gtp";
ssstrv[ss_ran] = "ran";
ssstrv[ss_sc0] = "sc0";
ssstrv[ss_sc1] = "sc1";

/* set the default strategies */

ssv[c_w] = ssv[c_b] = ss_eat;

/* set the function call entries */

ssdv[ss_eat][sep_init] = EATInit;
ssdv[ss_eat][sep_term] = EATTerm;
ssdv[ss_eat][sep_newgame] = EATNewGame;
ssdv[ss_eat][sep_select] = EATSelect;
ssdv[ss_eat][sep_play] = EATPlay;
ssdv[ss_eat][sep_unplay] = EATUnplay;
ssdv[ss_eat][sep_setpos] = EATSetPos;
ssdv[ss_eat][sep_config] = EATConfig;

ssdv[ss_gtp][sep_init] = GTPInit;
ssdv[ss_gtp][sep_term] = GTPTerm;
ssdv[ss_gtp][sep_newgame] = GTPNewGame;
ssdv[ss_gtp][sep_select] = GTPSelect;
ssdv[ss_gtp][sep_play] = GTPPlay;
ssdv[ss_gtp][sep_unplay] = GTPUnplay;
ssdv[ss_gtp][sep_setpos] = GTPSetPos;
ssdv[ss_gtp][sep_config] = GTPConfig;

ssdv[ss_ran][sep_init] = RANInit;
ssdv[ss_ran][sep_term] = RANTerm;
ssdv[ss_ran][sep_newgame] = RANNewGame;
ssdv[ss_ran][sep_select] = RANSelect;
ssdv[ss_ran][sep_play] = RANPlay;
ssdv[ss_ran][sep_unplay] = RANUnplay;
ssdv[ss_ran][sep_setpos] = RANSetPos;
ssdv[ss_ran][sep_config] = RANConfig;

ssdv[ss_sc0][sep_init] = SC0Init;
ssdv[ss_sc0][sep_term] = SC0Term;
ssdv[ss_sc0][sep_newgame] = SC0NewGame;
ssdv[ss_sc0][sep_select] = SC0Select;
ssdv[ss_sc0][sep_play] = SC0Play;
ssdv[ss_sc0][sep_unplay] = SC0Unplay;
ssdv[ss_sc0][sep_setpos] = SC0SetPos;
ssdv[ss_sc0][sep_config] = SC0Config;

ssdv[ss_sc1][sep_init] = SC1Init;
ssdv[ss_sc1][sep_term] = SC1Term;
ssdv[ss_sc1][sep_newgame] = SC1NewGame;
ssdv[ss_sc1][sep_select] = SC1Select;
ssdv[ss_sc1][sep_play] = SC1Play;
ssdv[ss_sc1][sep_unplay] = SC1Unplay;
ssdv[ss_sc1][sep_setpos] = SC1SetPos;
ssdv[ss_sc1][sep_config] = SC1Config;

/* initialize the searchers */

SANSSS(sep_init);

return;
}

/*--> SANSSSTerm: one time search strategy subsystem termination */
nonstatic
void
SANSSSTerm(void)
{
/* terminate the searchers */

SANSSS(sep_term);

return;
}

/*<<< sansss.c: EOF */
