/*>>> auto.c: SAN project stub for Beal Autoplay Protocol */

/* Revised: 1993.05.16 */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "sandef.h"

#include "sanbap.h"
#include "sandsp.h"
#include "sanmnd.h"
#include "sanmpu.h"
#include "sanutl.h"

int auto_startup(void);
int auto_readmove(int *move);
int auto_makemove(int move);

/*--> auto_startup: called by auto command to initiate autoplay */
nonstatic
int
auto_startup(void)
{
int flag;
mptrT mptr;
siT response;
char tv[tL], sv[tL];

flag = 1;

do
	{
	do
		{
		SANDspLine("AP: auto_startup: Is a move available (0=no, 1=yes)?");
		if (fgets(tv, tL, stdin) == NULL)
			SANFatal("auto_startup: unexpected EOF on input");
		response = -1;
		sscanf(tv, "%hd", &response);
		}
	while ((response != 0) && (response != 1));

	if (response == 1)
		{
		mptr = NULL;
		do
			{
			SANDspLine("AP: Enter outstanding move");
			if (fgets(tv, tL, stdin) == NULL)
				SANFatal("auto_startup: unexpected EOF on input");
			else
				{
				sscanf(tv, "%s", sv);
				mptr = SANDecodeAux(sv);
				if (mptr == NULL)
					SANDspLine("AP: Try again");
				else
					SANPlayMove(mptr);
				};
			}
		while (mptr == NULL);
		};
	}
while (flag && (response != 0));

return (flag ? 0 : 1);
}

/*--> auto_readmove: called to check on an incoming move */
nonstatic
int
auto_readmove(int *move)
{
int flag;
mptrT mptr;
siT msi;
siT response;
char tv[tL], sv[tL];

flag = 1;

do
	{
	SANDspLine("AP: auto_readmove: Is a move available (0=no, 1=yes)?");
	if (fgets(tv, tL, stdin) == NULL)
		SANFatal("auto_readmove: unexpected EOF on input");
	response = -1;
	sscanf(tv, "%hd", &response);
	}
while ((response != 0) && (response != 1));

if (response == 0)
	flag = 0;
else
	{
	mptr = NULL;
	do
		{
		SANDspLine("AP: Enter incoming move");
		if (fgets(tv, tL, stdin) == NULL)
			SANFatal("auto_readmove: unexpected EOF on input");
		else
			{
			sscanf(tv, "%s", sv);
			mptr = SANDecodeAux(sv);
			if (mptr == NULL)
				SANDspLine("AP: Try again");
			};
		}
	while (mptr == NULL);

	msi = SANBAPConvM(mptr);
	*move = (int) msi;
	};

return (flag ? 0 : 1);
}

/*--> auto_makemove: called to communicate an outgoing move */
nonstatic
int
auto_makemove(int move)
{
int flag;
siT msi;
siT response;
char tv[tL];

flag = 1;

msi = move;
SANDspStrSINL("AP: auto_makemove: outgoing move: ", msi);

do
	{
	SANDspLine("AP: Was move sent okay (0=no, 1=yes)?");
	if (fgets(tv, tL, stdin) == NULL)
		SANFatal("auto_makemove: unexpected EOF on input");
	response = -1;
	sscanf(tv, "%hd", &response);
	}
while ((response != 0) && (response != 1));

if (response == 0)
	flag = 0;

return (flag ? 0 : 1);
}

/*<<< auto.c: EOF */
