/*>>> sanrst.c: SAN project report status routines */

/* Revised: 1993.04.07 */

#include <stdio.h>

#include "sandef.h"
#include "sanvar.h"

#include "sanatk.h"
#include "sandrw.h"
#include "sanmlm.h"
#include "sanmsc.h"
#include "sanrst.h"

/*--> SANStatus: return current status */
nonstatic
gsT
SANStatus(void)
{
gsT gs;

/* set initial return value */

if (SANCensus() == cen_lgl)
	gs = gs_norm;
else
	gs = gs_bust;

/* test halfmove clock */

if (gs == gs_norm)
	if (curr_e.e_hmvc >= hmvcL)
		gs = gs_dhmc;

/* test for white checkmated */

if (gs == gs_norm)
	if (curr_e.e_actc == c_w)
		{
		SANMLEnsurePolice();
		if ((curr_g.g_gmvc == 0) && (SANAttack(c_b, plv[c_w][kingslot])))
			gs = gs_wcmt;
		};
		
/* test for black checkmated */

if (gs == gs_norm)
	if (curr_e.e_actc == c_b)
		{
		SANMLEnsurePolice();
		if ((curr_g.g_gmvc == 0) && (SANAttack(c_w, plv[c_b][kingslot])))
			gs = gs_bcmt;
		};

/* test for white stalemated */

if (gs == gs_norm)
	if ((curr_e.e_actc == c_w) && SANDrawTestSmat())
		gs = gs_wsmt;

/* test for black stalemated */

if (gs == gs_norm)
	if ((curr_e.e_actc == c_b) && SANDrawTestSmat())
		gs = gs_bsmt;

/* test for insufficient material */

if (gs == gs_norm)
	if (SANDrawTestIMat())
		gs = gs_dmat;

/* test for game overflow */

if (gs == gs_norm)
	if (curr_e.e_fmvn > fmpL)
		gs = gs_over;

return (gs);
}

/*<<< sanrst.c: EOF */
