/* ======== */
/* xvtanh.h */
/* ======== */
// After Cody & Waite and Plauger
#include "xverfun.h"
#define EXT_FUN 	xtanh
#define TST_FUN 	NAME(tanh)
// --------------------------|
// TstFun(x) versus ExtFun(x)|
// --------------------------|
qfloat f1 (qfloat x, qfloat &pzz)
{
    TYPE    FunArg;

    FunArg = (TYPE)xtold(x);

    pzz = EXT_FUN(FunArg);

    return NAME(tanh)(FunArg);
}
 // -------------------------------------------------------
// Main Program to Test tanh Function versus Extended tanh
// -------------------------------------------------------
#define EXT_FUN_STR	MAK_STR(EXT_FUN)
#define MAK_STR(x)	STR_NAME(x)
#define STR_NAME(x)	#x
#define	TEST_SIZE	1000
int
main()
{
    int 	    k;
    TYPE	    RadixPow;
    TYPE	    TanhAns, TanhArg;
    char	    Label[128];
    const char	   *FunStr = MAK_STR(NAME(tanh));
    MACHAR_STRU     MachData;
    qfloat	    HiLim, LoLim;

    printf("Test of %s(x) vs. %s(x):\n", FunStr, EXT_FUN_STR);

    MachData = GetMachar();

    printf("There are %d base %d significant digits\n\n",
	    MachData.FracDigs, MachData.Radix);

    LoLim = 0;
    HiLim = 0.625;

    sprintf(Label, "Test 1: %s(x) for %d values in "
		   "(%+.10LG, %+.10LG)", FunStr,
		   TEST_SIZE, xtold(LoLim), xtold(HiLim));

    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f1, Label);

    LoLim = 0.625;
    k     = ((MachData.FracDigs + 1) * MachData.Radix)/2;
    HiLim = k + xlog(2);

    sprintf(Label, "Test 2: %s(x) for %d values in "
		"(%s, %d+log(2))", FunStr, TEST_SIZE,
		"+0.0625", k);

    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f1, Label);

    printf("SPECIAL VALUES:\n");
    printf("\nThe following calls should "
	   "not trigger error messages:\n");

    printf("\n\tTesting %s(x) vs. %s(-x) for "
	   "random Values in [0, 3)\n",
	   FunStr, FunStr);

    for (k = 1; k <= 5; ++k)
    {
	TYPE	TanhArg1, TanhArg2;

	TanhArg1 = (TYPE)LDURand() * (TYPE) 3;
	TanhArg2 = -TanhArg1;
	TanhAns  = NAME(tanh)(TanhArg1) + NAME(tanh)(TanhArg2);

	printf("\t\tx = %.10Lf, %s(x) + %s(-x) = %+.25LG\n",
		(LDBL)TanhArg1, FunStr,
		FunStr, (LDBL) TanhAns);
    }
    fflush(NULL);

    RadixPow = (TYPE)1;
    for (k = 1; k <= MachData.FracDigs-1; ++k)
	RadixPow *= (TYPE)MachData.Radix;

    TanhArg = (TYPE) (LDURand() / RadixPow);

    printf("\n\tTesting %s(x) - x for small values of x\n" ,
	   FunStr);
    for (k = 0; k < 5; ++k)
    {
	TanhArg /= (TYPE) MachData.Radix;
	TanhAns = NAME(tanh)(TanhArg) - TanhArg;
	printf("\t\tx = %.10LG, %s(x) - x = %.10LG\n",
	    (LDBL) TanhArg, FunStr, (LDBL) TanhAns);
    }

    printf("\n\tTesting %s(x) - 1 for large x\n", FunStr);

    TanhArg = (TYPE) (0.5 * (MachData.FracDigs + 1) *
		     MachData.Radix + NAME(log)(2));

    for (k = 1; k <= 5; ++k)
    {
	TanhAns = NAME(tanh)(TanhArg) - (TYPE) 1;
	printf("\t\tx = %.10Lf, %s(x) - 1 = %.25LG\n",
		(LDBL) TanhArg, FunStr, (LDBL) TanhAns);

	TanhArg += (TYPE) 4;
    }
    printf("\n\tTesting underflow in %s(x) "
	   "for very small x:\n", FunStr);

    TanhArg = (TYPE) 1;
    for (k = 1; k <= -3 * (MachData.MinExp / 4); ++k)
	TanhArg /= (TYPE) MachData.Radix;

    TanhAns = NAME(tanh)(TanhArg);

    fflush(NULL);
    printf("\t\tx = %.10LG, %s(x) = %.10LG\n",
	(LDBL) TanhArg, FunStr, (LDBL) TanhAns);
    fflush(NULL);

    printf("\nBOUNDARY VALUES:\n");

    printf("\tTesting %s(x) for x = maximum "
	   "floating point value\n", FunStr);
    TanhArg = MachData.Max;
    TanhAns = NAME(tanh)(TanhArg);
    printf("\t\tx = %.10LG, %s(x) = %.10LG\n",
	(LDBL) TanhArg, FunStr, (LDBL) TanhAns);

    printf("\tTesting %s(x) for x = minimum "
	   "floating point value\n", FunStr);

    TanhArg = MachData.Min;
    TanhAns = NAME(tanh)(TanhArg);
    printf("\t\tx = %.10LG, %s(x) = %.10LG\n",
	(LDBL) TanhArg, FunStr, (LDBL) TanhAns);

    printf("\tTesting %s(x) for x = 0\n", FunStr);

    TanhArg = 0;
    TanhAns = NAME(tanh)(TanhArg);
    printf("\t\tx = %.10LG, %s(x) = %.10LG\n",
	(LDBL) TanhArg, FunStr, (LDBL) TanhAns);

    return (0);
}
